/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.dev;

import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.napkinlaf.dev.GeneratorTest;
import net.sourceforge.napkinlaf.util.RandomValue;
import net.sourceforge.napkinlaf.util.RandomValueSource;

class RandomValueSpinner
extends JPanel
implements RandomValueSource {
    private final RandomValue value;
    private final SpinnerNumberModel midModel;
    private SpinnerNumberModel rangeModel;
    private JLabel adjustLabel;

    RandomValueSpinner(String name, RandomValue value, double min, double max, int steps) {
        this(name, value, min, max, steps, true);
    }

    RandomValueSpinner(String name, final RandomValue value, double min, double max, int steps, boolean randomized) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new TitledBorder(name));
        this.value = value;
        double range = value.getRange();
        double init = value.getMid();
        double stepSize = (max - min) / (double)steps;
        this.midModel = new SpinnerNumberModel(init, min, max, stepSize);
        this.add(new JLabel(randomized ? "mid" : "val"));
        this.add(RandomValueSpinner.makeSpinner(this.midModel, "#0.00"));
        this.midModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                value.setMid(RandomValueSpinner.this.midModel.getNumber().doubleValue());
            }
        });
        if (randomized) {
            this.add(new JLabel("range"));
            this.add(this.makeRandomizer(range));
            this.add(new JLabel("adj "));
            this.adjustLabel = new JLabel("", 4);
            this.showAdjust();
            this.add(this.adjustLabel);
        }
    }

    private JSpinner makeRandomizer(double range) {
        this.rangeModel = new SpinnerNumberModel(range, 0.0, 20.0, 0.1);
        this.rangeModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                RandomValueSpinner.this.value.setRange(RandomValueSpinner.this.rangeModel.getNumber().doubleValue());
            }
        });
        return RandomValueSpinner.makeSpinner(this.rangeModel, GeneratorTest.DECIMAL.toPattern());
    }

    private void showAdjust() {
        if (this.adjustLabel != null) {
            double adjust = this.value.getAdjust();
            this.adjustLabel.setText(GeneratorTest.DECIMAL.format(adjust));
        }
    }

    private static JSpinner makeSpinner(SpinnerModel model, String pattern) {
        JSpinner spinner = new JSpinner(model);
        DecimalFormat format = ((JSpinner.NumberEditor)spinner.getEditor()).getFormat();
        format.applyPattern(pattern);
        model.addChangeListener(GeneratorTest.NEWPOINTS);
        return spinner;
    }

    public void randomize() {
        this.value.randomize();
        this.showAdjust();
    }

    public double get() {
        return this.value.get();
    }

    public double generate() {
        return this.value.generate();
    }

    public double getMid() {
        return this.value.getMid();
    }

    public double getRange() {
        return this.value.getRange();
    }

    public double getAdjust() {
        return this.value.getAdjust();
    }
}

