/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.dev;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.metal.MetalLookAndFeel;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.SketchedIcon;
import net.sourceforge.napkinlaf.sketch.Template;
import net.sourceforge.napkinlaf.sketch.sketchers.DraftSketcher;
import net.sourceforge.napkinlaf.sketch.sketchers.IdealSketcher;
import net.sourceforge.napkinlaf.sketch.sketchers.JotSketcher;
import net.sourceforge.napkinlaf.sketch.sketchers.LineSketcher;

public class SketchTest
implements ActionListener {
    private static final int IDEAL = 0;
    private static final int JOT = 1;
    private static final int LINE = 2;
    private static final int DRAFTSMAN = 3;
    private static final int DEFAULT = 0;
    private SketchedIcon templateIcon;
    private static JFrame templateTestFrame;
    private static JMenuBar menuBar;
    private final JPanel mainPanel;
    private final JPanel selectPanel;
    private final JPanel displayPanel;
    private JMenuItem openMenuItem;
    private JMenuItem exitMenuItem;
    private final JFileChooser fileChooser = new JFileChooser(SketchTest.currentDir());
    private JComboBox sketchChoices;
    private JButton sketchButton;
    private JButton reloadButton;
    private JLabel templateImageLabel;
    private boolean isNapkinLAF;
    private File file;

    public SketchTest() {
        XMLFilter fileFilter = new XMLFilter();
        this.fileChooser.setFileFilter(fileFilter);
        DrawnIconFileView diFileView = new DrawnIconFileView();
        this.fileChooser.setFileView(diFileView);
        this.selectPanel = new JPanel();
        this.displayPanel = new JPanel();
        this.addWidgets();
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 3));
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 50, 20));
        this.mainPanel.add(this.selectPanel);
        this.mainPanel.add(this.displayPanel);
    }

    private static File currentDir() {
        File curDir = new File(".");
        try {
            return curDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(curDir.getAbsolutePath(), e);
        }
    }

    private void addMenuWidgets() {
        menuBar = new JMenuBar();
        JMenu menu = new JMenu("File");
        menu.setMnemonic(70);
        menu.getAccessibleContext().setAccessibleDescription("The File Menu");
        this.openMenuItem = new JMenuItem("Open Template", 79);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.openMenuItem.getAccessibleContext().setAccessibleDescription("Opens an XML template file");
        this.openMenuItem.addActionListener(this);
        menu.add(this.openMenuItem);
        this.exitMenuItem = new JMenuItem("Exit", 88);
        this.openMenuItem.getAccessibleContext().setAccessibleDescription("Exits the program");
        this.exitMenuItem.addActionListener(this);
        menu.add(this.exitMenuItem);
        menuBar.add(menu);
        menu = new JMenu("Look & Feel");
        menu.setMnemonic(76);
        menu.getAccessibleContext().setAccessibleDescription("The Look & Feel Menu");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem("Java Look & Feel");
        rbMenuItem.setActionCommand("Java Look & Feel");
        rbMenuItem.setMnemonic(74);
        rbMenuItem.getAccessibleContext().setAccessibleDescription("Changes the GUI to the Java Look & Feel");
        rbMenuItem.addActionListener(this);
        rbMenuItem.setSelected(true);
        group.add(rbMenuItem);
        menu.add(rbMenuItem);
        rbMenuItem = new JRadioButtonMenuItem("Napkin Look & Feel");
        rbMenuItem.setActionCommand("Napkin Look & Feel");
        rbMenuItem.setMnemonic(78);
        rbMenuItem.getAccessibleContext().setAccessibleDescription("Changes the GUI to the Napkin Look & Feel");
        rbMenuItem.addActionListener(this);
        group.add(rbMenuItem);
        menu.add(rbMenuItem);
        menuBar.add(menu);
    }

    private void addWidgets() {
        this.addMenuWidgets();
        this.templateImageLabel = new JLabel();
        String[] sketchStyles = new String[]{"Ideal", "Jot", "StraightLine", "Draftsman"};
        this.sketchChoices = new JComboBox<String>(sketchStyles);
        this.sketchChoices.setSelectedIndex(0);
        this.sketchChoices.setEnabled(false);
        this.sketchButton = new JButton("Re-sketch");
        this.sketchButton.setEnabled(false);
        this.reloadButton = new JButton("Reload");
        this.reloadButton.setEnabled(false);
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SketchTest.this.loadFile();
            }
        });
        this.selectPanel.setBorder(BorderFactory.createTitledBorder("Select Sketch Style"));
        this.displayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Generated Icon"), BorderFactory.createEmptyBorder(10, 100, 10, 100)));
        this.displayPanel.add(this.templateImageLabel);
        this.selectPanel.add(this.sketchChoices);
        this.selectPanel.add(this.sketchButton);
        this.selectPanel.add(this.reloadButton);
        this.sketchChoices.addActionListener(this);
        this.sketchButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        int returnVal;
        int sketchStyle = this.sketchChoices.getSelectedIndex();
        if ("comboBoxChanged".equals(event.getActionCommand())) {
            this.templateIcon.setSketchStyle(SketchTest.getSketchStyle(sketchStyle));
            this.templateImageLabel.setIcon(this.templateIcon);
            this.templateImageLabel.repaint();
        }
        if (event.getSource() == this.sketchButton) {
            this.templateIcon.setSketched(false);
            this.templateImageLabel.repaint();
        }
        if (event.getSource() == this.openMenuItem && (returnVal = this.fileChooser.showOpenDialog(this.mainPanel)) == 0) {
            this.file = this.fileChooser.getSelectedFile();
            this.loadFile();
            this.sketchChoices.setEnabled(true);
            this.sketchButton.setEnabled(true);
            this.reloadButton.setEnabled(true);
        }
        if (event.getSource() == this.exitMenuItem) {
            System.exit(1);
        }
        if ("Java Look & Feel".equals(event.getActionCommand())) {
            MetalLookAndFeel laf = new MetalLookAndFeel();
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
            SwingUtilities.updateComponentTreeUI(templateTestFrame);
            SwingUtilities.updateComponentTreeUI(this.fileChooser);
            this.isNapkinLAF = false;
        }
        if ("Napkin Look & Feel".equals(event.getActionCommand())) {
            NapkinLookAndFeel laf = new NapkinLookAndFeel();
            try {
                UIManager.setLookAndFeel(laf);
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace();
            }
            SwingUtilities.updateComponentTreeUI(templateTestFrame);
            SwingUtilities.updateComponentTreeUI(this.fileChooser);
            this.isNapkinLAF = true;
        }
    }

    private void loadFile() {
        try {
            this.templateIcon = SketchTest.createDrawnIcon(this.file.getPath(), 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.templateImageLabel.setToolTipText(this.templateIcon.getTemplateDescription());
        this.templateImageLabel.setIcon(this.templateIcon);
        this.templateImageLabel.repaint();
    }

    private static SketchedIcon createDrawnIcon(String templatePath, int sketchStyle) {
        AbstractSketcher sketcher = SketchTest.getSketchStyle(sketchStyle);
        SketchedIcon ret = null;
        try {
            Template template = Template.createFromXML(templatePath);
            ret = new SketchedIcon(template, sketcher);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(e);
        }
        return ret;
    }

    private static AbstractSketcher getSketchStyle(int sketchStyle) {
        AbstractSketcher sketcher;
        switch (sketchStyle) {
            case 0: {
                sketcher = new IdealSketcher();
                break;
            }
            case 1: {
                sketcher = new JotSketcher();
                break;
            }
            case 2: {
                sketcher = new LineSketcher();
                break;
            }
            case 3: {
                sketcher = new DraftSketcher();
                break;
            }
            default: {
                sketcher = new IdealSketcher();
            }
        }
        return sketcher;
    }

    private static void createAndShowGUI() {
        SketchTest sketches = new SketchTest();
        templateTestFrame = new JFrame("Sketch Test");
        templateTestFrame.setDefaultCloseOperation(3);
        templateTestFrame.setContentPane(sketches.mainPanel);
        templateTestFrame.setJMenuBar(menuBar);
        templateTestFrame.pack();
        templateTestFrame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SketchTest.createAndShowGUI();
            }
        });
    }

    class DrawnIconFileView
    extends FileView {
        DrawnIconFileView() {
        }

        public Icon getIcon(File f) {
            SketchedIcon icon = null;
            if (f.isDirectory() && SketchTest.this.isNapkinLAF) {
                icon = SketchTest.this.templateIcon;
            }
            return icon;
        }
    }

    static class XMLFilter
    extends FileFilter {
        XMLFilter() {
        }

        public boolean accept(File pathname) {
            if (pathname.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(pathname);
            return extension != null && extension.equals("xml");
        }

        public String getDescription() {
            return "XML Templates";
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }
    }
}

