/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.examples;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import net.sourceforge.napkinlaf.NapkinTheme;

public class NapkinQuickTest
implements SwingConstants {
    public static void main(final String[] args) throws Exception {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    NapkinQuickTest.createAndShowGUI(args);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    private static void createAndShowGUI(String[] args) throws Exception {
        if (args.length == 1) {
            if (!args[0].equals("none")) {
                UIManager.setLookAndFeel(args[0]);
            }
        } else {
            NapkinLookAndFeel laf = new NapkinLookAndFeel();
            UIManager.setLookAndFeel(laf);
        }
        final HashSet<JComponent> toDisable = new HashSet<JComponent>();
        final JFrame top = new JFrame();
        top.setDefaultCloseOperation(3);
        top.setBackground(Color.cyan);
        JTabbedPane tabbed = new JTabbedPane();
        JPanel mainPanel = new JPanel();
        tabbed.addTab("Main Stuff", mainPanel);
        top.getContentPane().add(tabbed);
        JLabel label = new JLabel("-- Label --");
        mainPanel.setLayout(new GridLayout(4, 2));
        mainPanel.add(label);
        toDisable.add(label);
        JCheckBox checkBox = new JCheckBox("Check?");
        mainPanel.add(checkBox);
        final JCheckBox disableButton = new JCheckBox("Disable");
        disableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean enable = !disableButton.isSelected();
                for (JComponent component : toDisable) {
                    component.setEnabled(enable);
                }
            }
        });
        mainPanel.add(disableButton);
        toDisable.add(checkBox);
        ButtonGroup bgrp = new ButtonGroup();
        JRadioButton r1 = new JRadioButton("Radio?");
        JRadioButton r2 = new JRadioButton("Radio!");
        bgrp.add(r1);
        bgrp.add(r2);
        mainPanel.add(r1);
        mainPanel.add(r2);
        toDisable.add(r1);
        toDisable.add(r2);
        String[] themeNames = NapkinTheme.Manager.themeNames();
        final JComboBox<String> comboBox = new JComboBox<String>(themeNames);
        String currentTheme = NapkinTheme.Manager.getCurrentTheme().getName();
        comboBox.setSelectedItem(currentTheme);
        comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    String name = (String)comboBox.getSelectedItem();
                    NapkinTheme.Manager.setCurrentTheme(name);
                    UIManager.setLookAndFeel(UIManager.getLookAndFeel());
                    SwingUtilities.updateComponentTreeUI(top);
                }
                catch (UnsupportedLookAndFeelException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        mainPanel.add(comboBox);
        toDisable.add(comboBox);
        JSlider slider = new JSlider(0, -100, 100, 0);
        int majorSpacing = 50;
        slider.setMajorTickSpacing(majorSpacing);
        slider.setMinorTickSpacing(10);
        slider.setPaintTicks(true);
        Hashtable<Integer, JComponent> labels = slider.createStandardLabels(majorSpacing);
        slider.setLabelTable(labels);
        slider.setPaintLabels(true);
        mainPanel.add(slider);
        toDisable.add(slider);
        final JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        final JTextArea textArea = new JTextArea();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 400) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(i);
            if (i > 0 && i % 20 == 0) {
                textArea.append(sb.toString());
                textArea.append("\n");
                sb.delete(0, 1000);
            }
            ++i;
        }
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.setPreferredSize(new Dimension(200, 100));
        textPanel.add((Component)scrollPane, "Center");
        JButton loadButton = new JButton("Load File");
        textPanel.add((Component)loadButton, "South");
        loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                int result = chooser.showOpenDialog(textPanel);
                if (result == 0) {
                    NapkinQuickTest.loadFile(textArea, chooser.getSelectedFile());
                }
            }
        });
        tabbed.addTab("Text", textPanel);
        JPanel fields = new JPanel();
        fields.setLayout(new BorderLayout());
        JTextField field = new JTextField("of dreams", 20);
        fields.add((Component)new JLabel("Field:"), "West");
        fields.add((Component)field, "Center");
        tabbed.addTab("Fields", fields);
        int i2 = 0;
        while (i2 < 4) {
            tabbed.addTab("Tab " + i2, new JLabel("Just a Label #" + i2, 0));
            ++i2;
        }
        JPanel tabCtrls = new JPanel();
        ButtonGroup ctlGrp = new ButtonGroup();
        tabCtrls.setLayout(new GridLayout(2, 2));
        NapkinQuickTest.addCtrl(tabbed, tabCtrls, ctlGrp, "top", 1, true);
        NapkinQuickTest.addCtrl(tabbed, tabCtrls, ctlGrp, "right", 4, false);
        NapkinQuickTest.addCtrl(tabbed, tabCtrls, ctlGrp, "left", 2, false);
        NapkinQuickTest.addCtrl(tabbed, tabCtrls, ctlGrp, "bottom", 3, false);
        tabbed.addTab("Controls", tabCtrls);
        top.pack();
        top.setVisible(true);
    }

    private static void loadFile(JTextArea textArea, File file) {
        block12: {
            Reader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(file));
                    textArea.read(in, file);
                }
                catch (IOException e) {
                    PrintWriter out = new PrintWriter(new StringWriter());
                    e.printStackTrace(out);
                    out.close();
                    textArea.setText(out.toString());
                    if (in == null) break block12;
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private static void addCtrl(final JTabbedPane tabs, Container ctrls, ButtonGroup grp, String lab, final int side, boolean on) {
        JRadioButton button = new JRadioButton(lab, on);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                tabs.setTabPlacement(side);
            }
        });
        grp.add(button);
        ctrls.add(button);
    }
}

