/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.util.RandomValue;
import net.sourceforge.napkinlaf.util.RandomXY;

public class DrawnTabGenerator
extends AbstractDrawnGenerator {
    private final RandomXY ul;
    private final RandomXY ur;
    private final RandomXY lr;
    private final RandomXY ll;
    private final RandomValue squeeze;
    private final int side;
    public static final DrawnTabGenerator LEFT_TAB = new DrawnTabGenerator(2);
    public static final DrawnTabGenerator RIGHT_TAB = new DrawnTabGenerator(4);
    public static final DrawnTabGenerator TOP_TAB = new DrawnTabGenerator(1);
    public static final DrawnTabGenerator BOTTOM_TAB = new DrawnTabGenerator(3);
    private static final int[] STARTS = new int[5];
    private static final DrawnTabGenerator[] SIDES;

    static {
        DrawnTabGenerator.STARTS[0] = -1;
        DrawnTabGenerator.STARTS[2] = 4;
        DrawnTabGenerator.STARTS[4] = 0;
        DrawnTabGenerator.STARTS[1] = 6;
        DrawnTabGenerator.STARTS[3] = 2;
        SIDES = new DrawnTabGenerator[5];
        DrawnTabGenerator.SIDES[0] = null;
        DrawnTabGenerator.SIDES[2] = LEFT_TAB;
        DrawnTabGenerator.SIDES[4] = RIGHT_TAB;
        DrawnTabGenerator.SIDES[1] = TOP_TAB;
        DrawnTabGenerator.SIDES[3] = BOTTOM_TAB;
    }

    public static DrawnTabGenerator generatorFor(int side) {
        if (side <= 0) {
            throw new IndexOutOfBoundsException();
        }
        return SIDES[side];
    }

    private DrawnTabGenerator(int side) {
        this.side = side;
        float shimmy = 0.03f;
        this.ul = new RandomXY(0.0, shimmy, 0.0, shimmy);
        this.ur = new RandomXY(1.0, shimmy, 0.0, shimmy);
        this.lr = new RandomXY(1.0, shimmy, 1.0, shimmy);
        this.ll = new RandomXY(0.0, shimmy, 1.0, shimmy);
        this.squeeze = new RandomValue(0.09, 0.001);
    }

    public Shape generate(AffineTransform matrix) {
        if (DrawnTabGenerator.getXScale(matrix) > 100.0) {
            this.setScales(0.008, 0.03);
        } else {
            this.setScales(0.03, 0.1);
        }
        GeneralPath tab = new GeneralPath();
        Point2D ulAt = this.ul.generate();
        Point2D urAt = this.ur.generate();
        Point2D llAt = this.ll.generate();
        Point2D lrAt = this.lr.generate();
        double xUL = ulAt.getX();
        double yUL = ulAt.getY();
        double xUR = urAt.getX();
        double yUR = urAt.getY();
        double xLR = lrAt.getX();
        double yLR = lrAt.getY();
        double xLL = llAt.getX();
        double yLL = llAt.getY();
        switch (this.side) {
            case 2: {
                yUL += this.squeeze.generate();
                yLL -= this.squeeze.generate();
                break;
            }
            case 4: {
                yUR += this.squeeze.generate();
                yLR -= this.squeeze.generate();
                break;
            }
            case 1: {
                xUL += this.squeeze.generate();
                xUR -= this.squeeze.generate();
                break;
            }
            case 3: {
                xLL += this.squeeze.generate();
                xLR -= this.squeeze.generate();
                break;
            }
            default: {
                throw new IllegalStateException("unknown side: " + this.side);
            }
        }
        double[] points = new double[]{xUL, yUL, xUR, yUR, xLR, yLR, xLL, yLL};
        matrix.transform(points, 0, points, 0, 4);
        int start = STARTS[this.side];
        double prevX = points[start++];
        double prevY = points[start++];
        int i = 0;
        while (i < 3) {
            start %= points.length;
            double x = points[start++];
            double y = points[start++];
            tab.append(DrawnTabGenerator.fromPts(prevX, prevY, x, y), false);
            prevX = x;
            prevY = y;
            ++i;
        }
        return tab;
    }

    private static Shape fromPts(double x0, double y0, double x1, double y1) {
        AffineTransform matrix = new AffineTransform();
        double dx = x1 - x0;
        double dy = y1 - y0;
        double len = Math.sqrt(dx * dx + dy * dy);
        matrix.translate(x0, y0);
        matrix.rotate(Math.atan2(dy, dx));
        matrix.scale(len / 100.0, 1.0);
        return DrawnTabGenerator.defaultLineGenerator(len).generate(matrix);
    }

    public RandomXY getUL() {
        return this.ul;
    }

    public RandomXY getUR() {
        return this.ur;
    }

    public RandomXY getLL() {
        return this.ll;
    }

    public RandomXY getLR() {
        return this.lr;
    }

    private static double getXScale(AffineTransform matrix) {
        Point2D[] points = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 0.0)};
        matrix.transform(points, 0, points, 0, 2);
        return points[0].distance(points[1]);
    }

    private void setScales(double shimmy, double meanSqueeze) {
        this.ul.getY().setRange(shimmy);
        this.ur.getY().setRange(shimmy);
        this.lr.getY().setRange(shimmy);
        this.ll.getY().setRange(shimmy);
        if (this.side == 2 || this.side == 4) {
            shimmy /= 10.0;
        }
        this.ul.getX().setRange(shimmy);
        this.ur.getX().setRange(shimmy);
        this.ll.getX().setRange(shimmy);
        this.lr.getX().setRange(shimmy);
        this.squeeze.setMid(meanSqueeze);
        this.squeeze.setRange(meanSqueeze / 100.0);
    }
}

