/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.shapes.DrawnShapeHolder;
import net.sourceforge.napkinlaf.shapes.DrawnTabGenerator;

public class DrawnTabHolder
extends DrawnShapeHolder {
    private int tabPlacement;
    private int x;
    private int y;
    private int w;
    private int h;
    private final Point2D breakBeg = new Point2D.Double();
    private final Point2D breakEnd = new Point2D.Double();

    public DrawnTabHolder(int tabPlacement) {
        super(DrawnTabGenerator.generatorFor(tabPlacement));
    }

    public void shapeUpToDate(int tabPlacement, int x, int y, int w, int h) {
        if (tabPlacement == this.tabPlacement && w == this.w && h == this.h && this.x == x && this.y == y) {
            return;
        }
        if (tabPlacement != this.tabPlacement) {
            this.gen = DrawnTabGenerator.generatorFor(tabPlacement);
        }
        AffineTransform matrix = new AffineTransform();
        matrix.translate(x, y);
        matrix.scale(w, h);
        this.shape = this.gen.generate(matrix);
        this.tabPlacement = tabPlacement;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.setBreak(tabPlacement, x, w, y, h);
    }

    private void setBreak(int tabPlacement, int x, int w, int y, int h) {
        DrawnTabGenerator tab = (DrawnTabGenerator)this.gen;
        switch (tabPlacement) {
            case 1: {
                this.breakBeg.setLocation((double)x + tab.getLL().getX().get() * (double)w, (double)y + tab.getLL().getY().get() * (double)h);
                this.breakEnd.setLocation((double)x + tab.getLR().getX().get() * (double)w, (double)y + tab.getLR().getY().get() * (double)h);
                break;
            }
            case 4: {
                this.breakBeg.setLocation((double)x + tab.getUL().getX().get() * (double)w, (double)y + tab.getUL().getY().get() * (double)h);
                this.breakEnd.setLocation((double)x + tab.getLL().getX().get() * (double)w, (double)y + tab.getLL().getY().get() * (double)h);
                break;
            }
            case 3: {
                this.breakBeg.setLocation((double)x + tab.getUR().getX().get() * (double)w, (double)y + tab.getUR().getY().get() * (double)h);
                this.breakEnd.setLocation((double)x + tab.getUL().getX().get() * (double)w, (double)y + tab.getUL().getY().get() * (double)h);
                break;
            }
            case 2: {
                this.breakBeg.setLocation((double)x + tab.getLR().getX().get() * (double)w, (double)y + tab.getLR().getY().get() * (double)h);
                this.breakEnd.setLocation((double)x + tab.getUR().getX().get() * (double)w, (double)y + tab.getUR().getY().get() * (double)h);
                break;
            }
            default: {
                throw new IllegalStateException("unknown side: " + tabPlacement);
            }
        }
    }

    public Point2D getBreakBeg() {
        return this.breakBeg;
    }

    public Point2D getBreakEnd() {
        return this.breakEnd;
    }
}

