/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.shapes.AbstractDrawnGenerator;
import net.sourceforge.napkinlaf.util.RandomValue;
import net.sourceforge.napkinlaf.util.RandomValueSource;
import net.sourceforge.napkinlaf.util.RandomXY;

public class DrawnTriangleGenerator
extends AbstractDrawnGenerator {
    private final RandomXY mid;
    private final RandomXY l;
    private final RandomXY r;
    private final RandomValue startAdjust;
    private final double rotate;

    public DrawnTriangleGenerator(double rotate) {
        this.rotate = rotate;
        double shimmy = 0.05;
        this.mid = new RandomXY(0.5, shimmy, 0.0, shimmy);
        this.l = new RandomXY(0.0, shimmy, 1.0, shimmy);
        this.r = new RandomXY(1.0, shimmy, 1.0, shimmy);
        this.startAdjust = new RandomValue(0.07);
    }

    public Shape generate(AffineTransform matrix) {
        GeneralPath t = new GeneralPath();
        double xScale = matrix.getScaleX();
        double yScale = matrix.getScaleY();
        Point2D midAt = this.mid.generate();
        Point2D leftAt = this.l.generate();
        Point2D rightAt = this.r.generate();
        double xMid = midAt.getX();
        double yMid = midAt.getY();
        double xV1 = leftAt.getX();
        double yV1 = leftAt.getY();
        double xV2 = rightAt.getX();
        double yV2 = rightAt.getY();
        if (this.rotate != 0.0) {
            matrix = (AffineTransform)matrix.clone();
            matrix.rotate(this.rotate, 0.5, 0.5);
        }
        double[] points = new double[]{xMid, yMid, xV1, yV1, xV2, yV2};
        matrix.transform(points, 0, points, 0, 3);
        double minDist = Double.MAX_VALUE;
        int minPoint = 0;
        int i = 0;
        while (i < points.length) {
            double x = points[i];
            double y = points[i + 1];
            double dist = Math.sqrt(x * x + y * y);
            if (dist < minDist) {
                minDist = dist;
                minPoint = i;
            }
            i += 2;
        }
        float[] drawPoints = new float[points.length + 2];
        int i2 = 0;
        while (i2 < points.length) {
            drawPoints[i2] = (float)points[(i2 + minPoint) % points.length];
            ++i2;
        }
        drawPoints[6] = drawPoints[0];
        drawPoints[7] = drawPoints[1];
        drawPoints[0] = (float)((double)drawPoints[0] + this.adjustStartOffset(this.startAdjust, xScale));
        drawPoints[1] = (float)((double)drawPoints[1] + this.adjustStartOffset(this.startAdjust, yScale));
        drawPoints[6] = (float)((double)drawPoints[6] + this.adjustStartOffset(this.startAdjust, xScale));
        drawPoints[7] = (float)((double)drawPoints[7] + this.adjustStartOffset(this.startAdjust, yScale));
        t.moveTo(drawPoints[0], drawPoints[1]);
        i2 = 2;
        while (i2 < drawPoints.length) {
            t.lineTo(drawPoints[i2], drawPoints[i2 + 1]);
            i2 += 2;
        }
        return t;
    }

    private double adjustStartOffset(RandomValueSource off, double scale) {
        if (scale >= 1.0) {
            return off.generate();
        }
        double delta = 1.0 - scale;
        double exp = this.startAdjust.generate();
        double adjusted = Math.pow(delta, exp);
        double startScale = 1.0 - adjusted;
        return off.generate() * startScale;
    }

    public RandomValue getStartAdjust() {
        return this.startAdjust;
    }
}

