/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.Template;

public class SketchedIcon
implements Icon {
    private final Template template;
    private AbstractSketcher sketcher;
    private BufferedImage bimage;
    private boolean isSketched;

    public SketchedIcon(Template template, AbstractSketcher sketcher) {
        this.template = template;
        this.sketcher = sketcher;
        this.isSketched = false;
    }

    public void setSketchStyle(AbstractSketcher sketchStyle) {
        this.sketcher = sketchStyle;
        this.isSketched = false;
    }

    public void setSketched(boolean isSketched) {
        this.isSketched = isSketched;
    }

    public String getTemplateTitle() {
        return this.template.getTitle();
    }

    public String getTemplateDescription() {
        return this.template.getDescription();
    }

    public int getIconHeight() {
        return (int)this.template.getClippingBounds().getHeight();
    }

    public int getIconWidth() {
        return (int)this.template.getClippingBounds().getWidth();
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int width = this.template.getClippingBounds().width;
        int height = this.template.getClippingBounds().height;
        Graphics2D g2d = (Graphics2D)g.create(x, y, width, height);
        if (!this.isSketched) {
            this.bimage = new BufferedImage(width, height, 2);
            Graphics2D imageGraphics = this.bimage.createGraphics();
            this.sketcher.sketch(this.template.clone(), imageGraphics);
            g2d.drawImage(this.bimage, 0, 0, width, height, null);
            this.isSketched = true;
        } else if (this.bimage != null) {
            g2d.drawImage(this.bimage, 0, 0, width, height, null);
        }
        g2d.dispose();
    }
}

