/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.sourceforge.napkinlaf.NapkinLookAndFeel;
import net.sourceforge.napkinlaf.sketch.Template;
import net.sourceforge.napkinlaf.sketch.TemplateItem;
import net.sourceforge.napkinlaf.sketch.TemplateReadException;
import net.sourceforge.napkinlaf.sketch.XMLActions;
import net.sourceforge.napkinlaf.sketch.geometry.CubicLine;
import net.sourceforge.napkinlaf.sketch.geometry.Path;
import net.sourceforge.napkinlaf.sketch.geometry.QuadLine;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.StraightLine;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTemplateExtractor
extends DefaultHandler {
    private final Template template = new Template();
    private TemplateItem templateItem;
    private Dimension dimensions;
    private SketchShape shape;
    private StraightLine straightLine;
    private CubicLine cubicLine;
    private QuadLine quadLine;
    private Path path;
    private Point2D point = new Point2D.Float();
    private final Point2D.Float[] points = new Point2D.Float[4];
    private int i = 0;
    private int[] rgb;
    private XMLActions currentAction;
    private float curX;
    private static final String VALIDATE_PROP = "net.sourceforge.napkinlaf.validate";
    private static final boolean VALIDATE;
    private static final String SCHEMA_URL;

    static {
        boolean v;
        try {
            v = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return Boolean.getBoolean(XMLTemplateExtractor.VALIDATE_PROP);
                }
            });
        }
        catch (SecurityException e) {
            v = false;
        }
        VALIDATE = v;
        SCHEMA_URL = NapkinLookAndFeel.class.getResource("resources/templates/Template.xsd").toString();
    }

    public XMLTemplateExtractor() {
        this.points[0] = new Point2D.Float();
        this.points[1] = new Point2D.Float();
        this.points[2] = new Point2D.Float();
        this.points[3] = new Point2D.Float();
        this.currentAction = XMLActions.NO_ACTION;
    }

    public void startElement(String namespace, String localName, String qualifiedName, Attributes attribs) {
        if ("title".equals(localName)) {
            this.currentAction = XMLActions.GET_TEMPLATE_TITLE;
        } else if ("description".equals(localName)) {
            this.currentAction = XMLActions.GET_TEMPLATE_DESCRIPTION;
        } else if ("clippingBounds".equals(localName)) {
            this.dimensions = new Dimension();
        } else if ("width".equals(localName)) {
            this.currentAction = XMLActions.GET_TEMPLATE_CLIP_WIDTH;
        } else if ("height".equals(localName)) {
            this.currentAction = XMLActions.GET_TEMPLATE_CLIP_HEIGHT;
        } else if ("templateItem".equals(localName)) {
            this.templateItem = new TemplateItem();
        } else if ("drawStroke".equals(localName)) {
            this.currentAction = XMLActions.GET_DRAW_STROKE;
        } else if ("drawFill".equals(localName)) {
            this.currentAction = XMLActions.GET_DRAW_FILL;
        } else if ("strokeWeight".equals(localName)) {
            this.currentAction = XMLActions.GET_STROKE_WEIGHT;
        } else if ("strokeColor".equals(localName)) {
            this.rgb = new int[3];
        } else if ("fillColor".equals(localName)) {
            this.rgb = new int[3];
        } else if ("straightLine".equals(localName)) {
            this.i = 0;
            this.straightLine = new StraightLine();
        } else if ("quadLine".equals(localName)) {
            this.i = 0;
            this.quadLine = new QuadLine();
        } else if ("cubicLine".equals(localName)) {
            this.i = 0;
            this.cubicLine = new CubicLine();
        } else if ("path".equals(localName)) {
            this.i = 0;
            this.path = new Path();
        } else if ("moveTo".equals(localName)) {
            this.i = 0;
        } else if ("quadTo".equals(localName)) {
            this.i = 0;
        } else if ("cubicTo".equals(localName)) {
            this.i = 0;
        } else if ("r".equals(localName)) {
            this.currentAction = XMLActions.GET_R_VALUE;
        } else if ("g".equals(localName)) {
            this.currentAction = XMLActions.GET_G_VALUE;
        } else if ("b".equals(localName)) {
            this.currentAction = XMLActions.GET_B_VALUE;
        } else if ("x".equals(localName)) {
            this.currentAction = XMLActions.GET_X_VALUE;
        } else if ("y".equals(localName)) {
            this.currentAction = XMLActions.GET_Y_VALUE;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.currentAction != XMLActions.NO_ACTION) {
            String value = new String(ch, start, length);
            switch (this.currentAction) {
                case GET_TEMPLATE_TITLE: {
                    this.template.setTitle(value);
                    break;
                }
                case GET_TEMPLATE_DESCRIPTION: {
                    this.template.setDescription(value);
                    break;
                }
                case GET_TEMPLATE_CLIP_WIDTH: {
                    this.dimensions.width = Integer.parseInt(value);
                    break;
                }
                case GET_TEMPLATE_CLIP_HEIGHT: {
                    this.dimensions.height = Integer.parseInt(value);
                    break;
                }
                case GET_DRAW_STROKE: {
                    this.templateItem.setDrawStroke(Boolean.valueOf(value));
                    break;
                }
                case GET_DRAW_FILL: {
                    this.templateItem.setDrawFill(Boolean.valueOf(value));
                    break;
                }
                case GET_STROKE_WEIGHT: {
                    this.templateItem.setStrokeWeight(Float.parseFloat(value));
                    break;
                }
                case GET_R_VALUE: {
                    this.rgb[0] = Integer.parseInt(value);
                    break;
                }
                case GET_G_VALUE: {
                    this.rgb[1] = Integer.parseInt(value);
                    break;
                }
                case GET_B_VALUE: {
                    this.rgb[2] = Integer.parseInt(value);
                    break;
                }
                case GET_X_VALUE: {
                    this.curX = Float.parseFloat(value);
                    break;
                }
                case GET_Y_VALUE: {
                    this.point = new Point2D.Float(this.curX, Float.parseFloat(value));
                    break;
                }
                case NO_ACTION: {
                    break;
                }
                default: {
                    throw new IllegalStateException((Object)((Object)this.currentAction) + ": unknown");
                }
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        if ("clippingBounds".equals(localName)) {
            Rectangle clippingBounds = new Rectangle(this.dimensions);
            this.template.setClippingBounds(clippingBounds);
        } else if ("templateItem".equals(localName)) {
            this.templateItem.setShape(this.shape);
            this.template.add(this.templateItem);
        } else if ("strokeColor".equals(localName)) {
            this.templateItem.setStrokeColor(new Color(this.rgb[0], this.rgb[1], this.rgb[2]));
        } else if ("fillColor".equals(localName)) {
            this.templateItem.setFillColor(new Color(this.rgb[0], this.rgb[1], this.rgb[2]));
        } else if ("straightLine".equals(localName)) {
            this.straightLine.x1 = this.points[0].x;
            this.straightLine.y1 = this.points[0].y;
            this.straightLine.x2 = this.points[1].x;
            this.straightLine.y2 = this.points[1].y;
            this.shape = this.straightLine;
        } else if ("quadLine".equals(localName)) {
            this.quadLine.x1 = this.points[0].x;
            this.quadLine.y1 = this.points[0].y;
            this.quadLine.ctrlx = this.points[1].x;
            this.quadLine.ctrly = this.points[1].y;
            this.quadLine.x2 = this.points[2].x;
            this.quadLine.y2 = this.points[2].y;
            this.shape = this.quadLine;
        } else if ("cubicLine".equals(localName)) {
            this.cubicLine.x1 = this.points[0].x;
            this.cubicLine.y1 = this.points[0].y;
            this.cubicLine.ctrlx1 = this.points[1].x;
            this.cubicLine.ctrly1 = this.points[1].y;
            this.cubicLine.ctrlx2 = this.points[2].x;
            this.cubicLine.ctrly2 = this.points[2].y;
            this.cubicLine.x2 = this.points[3].x;
            this.cubicLine.y2 = this.points[3].y;
            this.shape = this.cubicLine;
        } else if ("path".equals(localName)) {
            this.shape = this.path;
        } else if ("moveTo".equals(localName)) {
            this.path.moveTo(this.points[0].x, this.points[0].y);
            this.i = 0;
        } else if ("lineTo".equals(localName)) {
            this.path.lineTo(this.points[0].x, this.points[0].y);
            this.i = 0;
        } else if ("quadTo".equals(localName)) {
            this.path.quadTo(this.points[0].x, this.points[0].y, this.points[1].x, this.points[1].y);
            this.i = 0;
        } else if ("cubicTo".equals(localName)) {
            this.path.curveTo(this.points[0].x, this.points[0].y, this.points[1].x, this.points[1].y, this.points[2].x, this.points[2].y);
            this.i = 0;
        } else if ("close".equals(localName)) {
            this.path.closePath();
        } else if ("start".equals(localName) || "point".equals(localName) || "control".equals(localName) || "end".equals(localName)) {
            this.points[this.i++] = (Point2D.Float)this.point.clone();
        }
        this.currentAction = XMLActions.NO_ACTION;
    }

    public void error(SAXParseException e) {
        XMLTemplateExtractor.printError("Error", e);
    }

    public void warning(SAXParseException e) {
        XMLTemplateExtractor.printError("Warning", e);
    }

    public void fatalError(SAXParseException e) {
        XMLTemplateExtractor.printError("Fatal Error", e);
    }

    protected static void printError(String type, SAXParseException e) {
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        String systemId = e.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(e.getLineNumber());
        System.err.print(':');
        System.err.print(e.getColumnNumber());
        System.err.print(": ");
        System.err.print(e.getMessage());
        System.err.println();
        System.err.flush();
    }

    public Template createTemplate(InputStream in) throws TemplateReadException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            try {
                reader.setFeature("http://xml.org/sax/features/namespaces", true);
                if (VALIDATE) {
                    reader.setFeature("http://xml.org/sax/features/validation", true);
                    reader.setFeature("http://apache.org/xml/features/validation/schema", true);
                    reader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                    reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", SCHEMA_URL);
                }
            }
            catch (SAXException e) {
                e.printStackTrace();
                System.err.println("Warning: Parser does not support schema validation");
            }
            parser.parse(in, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new TemplateReadException(e);
        }
        catch (SAXException e) {
            throw new TemplateReadException(e);
        }
        catch (IOException e) {
            throw new TemplateReadException(e);
        }
        return this.template;
    }
}

