/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch.geometry;

import java.awt.geom.CubicCurve2D;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.geometry.Path;
import net.sourceforge.napkinlaf.sketch.geometry.Point;
import net.sourceforge.napkinlaf.sketch.geometry.QuadLine;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.StraightLine;
import net.sourceforge.napkinlaf.sketch.geometry.XMLCubicLine;

public class CubicLine
extends CubicCurve2D.Double
implements SketchShape {
    public CubicLine() {
    }

    public CubicLine(double x1, double y1, double ctlx1, double ctly1, double ctlx2, double ctly2, double x2, double y2) {
        super(x1, y1, ctlx1, ctly1, ctlx2, ctly2, x2, y2);
    }

    public CubicLine(Point2D p1, Point2D ctl1, Point2D ctl2, Point2D p2) {
        super(p1.getX(), p1.getY(), ctl1.getX(), ctl1.getY(), ctl2.getX(), ctl2.getY(), p2.getX(), p2.getY());
    }

    public double approximateLength() {
        StraightLine s1 = new StraightLine(this.getP1(), this.getCtrlP1());
        StraightLine s2 = new StraightLine(this.getCtrlP1(), this.getCtrlP2());
        StraightLine s3 = new StraightLine(this.getCtrlP2(), this.getP2());
        return (s1.length() + s2.length() + s3.length()) / (1.0 + Math.log(this.getFlatness() + 1.0));
    }

    public SketchShape magnify(double scaleFactor) {
        return new XMLCubicLine(this.x1 * scaleFactor, this.y1 * scaleFactor, this.ctrlx1 * scaleFactor, this.ctrly1 * scaleFactor, this.ctrlx2 * scaleFactor, this.ctrly2 * scaleFactor, this.x2 * scaleFactor, this.y2 * scaleFactor);
    }

    public CubicLine transformToCubic() {
        return this;
    }

    public Path transformToPath() {
        Path ret = new Path();
        Point s = new Point(this.getP1());
        Point c1 = new Point(this.getCtrlP1());
        Point c2 = new Point(this.getCtrlP2());
        Point f = new Point(this.getP2());
        ret.moveTo(s.floatX(), s.floatY());
        ret.curveTo(c1.floatX(), c1.floatY(), c2.floatX(), c2.floatY(), f.floatX(), f.floatY());
        return ret;
    }

    public StraightLine[] transformToLine() {
        Point mid = Point.midpoint(this.getP1(), this.getP2());
        Point q1 = Point.midpoint(this.getP1(), mid);
        Point q3 = Point.midpoint(mid, this.getP2());
        StraightLine span = new StraightLine(q1, this.getCtrlP1());
        double lenmultiplier = 0.4;
        if (span.x2 < span.x1 || span.x2 == span.x1 && span.y2 < span.y1) {
            lenmultiplier *= -1.0;
        }
        Point p1 = new Point(q1, span.angle(), span.length() * lenmultiplier);
        span = new StraightLine(q3, this.getCtrlP2());
        lenmultiplier = 0.4;
        if (span.x2 < span.x1 || span.x2 == span.x1 && span.y2 < span.y1) {
            lenmultiplier *= -1.0;
        }
        Point p2 = new Point(q3, span.angle(), span.length() * lenmultiplier);
        span = new StraightLine(this.getP1(), this.getCtrlP1());
        lenmultiplier = 0.6;
        if (span.x2 < span.x1 || span.x2 == span.x1 && span.y2 < span.y1) {
            lenmultiplier *= -1.0;
        }
        Point s1 = new Point(this.getP1(), span.angle(), span.length() * lenmultiplier);
        span = new StraightLine(this.getP2(), this.getCtrlP2());
        lenmultiplier = 0.6;
        if (span.x2 < span.x1 || span.x2 == span.x1 && span.y2 < span.y1) {
            lenmultiplier *= -1.0;
        }
        Point s2 = new Point(this.getP2(), span.angle(), span.length() * lenmultiplier);
        Point one = Point.midpoint(p1, s1);
        Point two = Point.midpoint(p2, s2);
        StraightLine[] ret = new StraightLine[]{new StraightLine(this.getP1(), one), new StraightLine(one, two), new StraightLine(two, this.getP2())};
        return ret;
    }

    public QuadLine[] transformToQuad() {
        StraightLine line = new StraightLine(this.getP1(), this.getP2());
        Point intersection = line.intersects(new StraightLine(this.getCtrlP1(), this.getCtrlP2()));
        QuadLine[] ret = intersection == null ? new QuadLine[]{new QuadLine(this.getP1(), Point.midpoint(this.getCtrlP1(), this.getCtrlP2()), this.getP2())} : new QuadLine[]{new QuadLine(this.getP1(), this.getCtrlP1(), intersection), new QuadLine(intersection, this.getCtrlP2(), this.getP2())};
        return ret;
    }

    public SketchShape deform(AbstractSketcher r) {
        return r.deformCubic(this);
    }

    public CubicLine[] transformToCubicList() {
        CubicLine[] ret = new CubicLine[]{this.transformToCubic()};
        return ret;
    }

    public CubicLine clone() {
        return (CubicLine)super.clone();
    }
}

