/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch.geometry;

import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import net.sourceforge.napkinlaf.sketch.AbstractSketcher;
import net.sourceforge.napkinlaf.sketch.geometry.CubicLine;
import net.sourceforge.napkinlaf.sketch.geometry.Path;
import net.sourceforge.napkinlaf.sketch.geometry.Point;
import net.sourceforge.napkinlaf.sketch.geometry.SketchShape;
import net.sourceforge.napkinlaf.sketch.geometry.StraightLine;
import net.sourceforge.napkinlaf.sketch.geometry.XMLQuadLine;

public class QuadLine
extends QuadCurve2D.Double
implements SketchShape {
    public QuadLine() {
    }

    public QuadLine(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
        super(x1, y1, ctrlx, ctrly, x2, y2);
    }

    public QuadLine(Point2D p1, Point2D ctrlpt, Point2D p2) {
        super(p1.getX(), p1.getY(), ctrlpt.getX(), ctrlpt.getY(), p2.getX(), p2.getY());
    }

    public SketchShape magnify(double scaleFactor) {
        return new XMLQuadLine(this.x1 * scaleFactor, this.y1 * scaleFactor, this.ctrlx * scaleFactor, this.ctrly * scaleFactor, this.x2 * scaleFactor, this.y2 * scaleFactor);
    }

    public CubicLine transformToCubic() {
        Point base = Point.midpoint(this.getP1(), this.getP2());
        StraightLine span = new StraightLine(base, this.getCtrlPt());
        double lenMultiplier = 0.6;
        if (span.x2 < span.x1) {
            lenMultiplier *= -1.0;
        }
        Point2D reach = new StraightLine(base, span.angle(), span.length() * lenMultiplier).getP2();
        return new CubicLine(this.getP1(), reach, reach, this.getP2());
    }

    public Path transformToPath() {
        Path ret = new Path();
        Point s = new Point(this.getP1());
        Point c = new Point(this.getCtrlPt());
        Point f = new Point(this.getP2());
        ret.moveTo(s.floatX(), s.floatY());
        ret.quadTo(c.floatX(), c.floatY(), f.floatX(), f.floatY());
        return ret;
    }

    public StraightLine[] transformToLine() {
        return this.transformToCubic().transformToLine();
    }

    public QuadLine[] transformToQuad() {
        QuadLine[] ret = new QuadLine[]{this.clone()};
        return ret;
    }

    public SketchShape deform(AbstractSketcher r) {
        return r.deformQuad(this);
    }

    public double approximateLength() {
        return this.transformToCubic().approximateLength();
    }

    public CubicLine[] transformToCubicList() {
        CubicLine[] ret = new CubicLine[]{this.transformToCubic()};
        return ret;
    }

    public QuadLine clone() {
        return (QuadLine)super.clone();
    }
}

