/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.Component;
import java.awt.Container;

public class ComponentWalker {
    private final Visitor visitor;

    public ComponentWalker(Visitor visitor) {
        this.visitor = visitor;
    }

    public void walk(Component top) {
        if (top != null) {
            this.visit(top, 0);
        }
    }

    private void visit(Component c, int depth) {
        if (!this.visitor.visit(c, depth)) {
            return;
        }
        int childDepth = depth + 1;
        if (c instanceof Container) {
            Container container = (Container)c;
            int end = container.getComponentCount();
            int i = 0;
            while (i < end) {
                this.visit(container.getComponent(i), childDepth);
                ++i;
            }
        }
    }

    public static interface Visitor {
        public boolean visit(Component var1, int var2);
    }
}

