/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.util;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Label;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NapkinDebug {
    private static final Map<Class<?>, Field[]> fieldsForType = new WeakHashMap();
    private static final Set<String> skip = new HashSet<String>();
    protected static int count;

    private NapkinDebug() {
    }

    public static void dumpObject(Object obj, String fileName) {
        PrintStream out = null;
        try {
            try {
                out = new PrintStream(new BufferedOutputStream(new FileOutputStream(fileName)));
                NapkinDebug.dumpObject(obj, out);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static String descFor(Object obj) {
        if (obj instanceof Component) {
            return NapkinDebug.descFor((Component)obj);
        }
        return obj.getClass().getName();
    }

    public static String descFor(Component c) {
        JComponent jc;
        Border border;
        if (c == null) {
            return "[null]";
        }
        String idStr = "[" + System.identityHashCode(c) + "]";
        String desc = c.getName();
        if (desc != null) {
            return String.valueOf(desc.trim()) + idStr + "/" + c.getClass().getName();
        }
        desc = c.getClass().getName();
        int dot = desc.lastIndexOf(46);
        if (dot > 0) {
            desc = desc.substring(dot + 1);
        }
        StringBuilder descStr = new StringBuilder(desc);
        descStr.append(idStr);
        if (c instanceof JLabel) {
            descStr.append(": ").append(((JLabel)c).getText());
        } else if (c instanceof AbstractButton) {
            descStr.append(": ").append(((AbstractButton)c).getText());
        } else if (c instanceof JTextComponent) {
            descStr.append(": ").append(((JTextComponent)c).getText());
        } else if (c instanceof JPopupMenu) {
            descStr.append(": ").append(((JPopupMenu)c).getLabel());
        } else if (c instanceof Label) {
            descStr.append(": ").append(((Label)c).getText());
        } else if (c instanceof Button) {
            descStr.append(": ").append(((Button)c).getLabel());
        } else if (c instanceof Checkbox) {
            descStr.append(": ").append(((Checkbox)c).getLabel());
        } else if (c instanceof Dialog) {
            descStr.append(": ").append(((Dialog)c).getTitle());
        } else if (c instanceof Frame) {
            descStr.append(": ").append(((Frame)c).getTitle());
        } else if (c instanceof JInternalFrame) {
            descStr.append(": ").append(((JInternalFrame)c).getTitle());
        }
        descStr = new StringBuilder(descStr.toString().trim());
        if (c instanceof JComponent && (border = (jc = (JComponent)c).getBorder()) instanceof TitledBorder) {
            descStr.append(": ").append(((TitledBorder)border).getTitle());
        }
        return descStr.toString().trim();
    }

    static void dumpTo(String file, JComponent c) {
        PrintWriter out = null;
        try {
            try {
                out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                HashSet<Object> dumped = new HashSet<Object>();
                NapkinDebug.dumpTo(out, c, c.getClass(), 0, dumped);
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (out != null) {
                    out.close();
                }
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static void dumpTo(PrintWriter out, Object obj, Class<?> cl, int level, Set<Object> dumped) throws IllegalAccessException {
        Field[] fields;
        if (cl == null) {
            return;
        }
        NapkinDebug.dumpTo(out, obj, cl.getSuperclass(), level, dumped);
        Field[] fieldArray = fields = cl.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.setAccessible(true);
            Object val = field.get(obj);
            int l = 0;
            while (l < level) {
                out.print("    ");
                ++l;
            }
            out.println(String.valueOf(field.getName()) + ": " + val);
            if (val != null && !dumped.contains(obj) && !field.getType().isPrimitive()) {
                NapkinDebug.dumpTo(out, val, val.getClass(), level + 1, dumped);
                dumped.add(obj);
            }
            ++n2;
        }
    }

    public static void dumpObject(Object obj, PrintStream out) {
        HashMap<Object, Integer> known = new HashMap<Object, Integer>();
        NapkinDebug.dumpObject(obj, out, 0, known);
    }

    private static void dumpObject(Object obj, PrintStream out, int depth, Map<Object, Integer> known) {
        Integer id = known.get(obj);
        if (id != null) {
            out.println("<known: " + id + ">");
            return;
        }
        id = known.size();
        known.put(obj, id);
        out.println(String.valueOf(NapkinDebug.descFor(obj)) + " <" + id + ">");
        try {
            Field[] fields;
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i <= depth) {
                sb.append(i % 2 == 0 ? (char)'.' : '|').append(' ');
                ++i;
            }
            String indent = sb.toString();
            Field[] fieldArray = fields = NapkinDebug.getFields(obj);
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!skip.contains(field.getName())) {
                    Class<?> type = field.getType();
                    out.print(indent);
                    out.print(String.valueOf(field.getName()) + " [" + field.getType().getName() + "]: ");
                    Object val = field.get(obj);
                    NapkinDebug.dumpValue(type, out, val, depth, known);
                }
                ++n2;
            }
            if (obj.getClass().isArray()) {
                Class<?> type = obj.getClass().getComponentType();
                int length = Array.getLength(obj);
                int i2 = 0;
                while (i2 < length) {
                    Object val = Array.get(obj, i2);
                    if (val != null) {
                        out.print(indent);
                        out.print(String.valueOf(i2) + ": ");
                        NapkinDebug.dumpValue(type, out, val, depth, known);
                    }
                    ++i2;
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static void dumpValue(Class<?> type, PrintStream out, Object val, int depth, Map<Object, Integer> known) {
        if (type.isPrimitive()) {
            out.println(val);
        } else if (val == null || type == String.class) {
            out.println(val);
        } else {
            if (type.isArray()) {
                Class<?> aType = type.getComponentType();
                out.println(" " + aType.getName() + "[" + Array.getLength(val) + "]");
            }
            NapkinDebug.dumpObject(val, out, depth + 1, known);
        }
    }

    private static Field[] getFields(Object obj) {
        Class<?> type = obj.getClass();
        AccessibleObject[] fields = fieldsForType.get(type);
        if (fields != null) {
            return fields;
        }
        HashSet<Field> fSet = new HashSet<Field>();
        int skip = 152;
        while (type != Object.class) {
            Field[] declaredFields;
            Field[] fieldArray = declaredFields = type.getDeclaredFields();
            int n = declaredFields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int mods = field.getModifiers();
                if (!field.getDeclaringClass().isAssignableFrom(obj.getClass())) {
                    fSet.size();
                }
                if ((mods & skip) == 0) {
                    fSet.add(field);
                }
                ++n2;
            }
            type = type.getSuperclass();
        }
        fields = fSet.toArray(new Field[fSet.size()]);
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                int d = f1.getName().compareTo(f2.getName());
                if (d != 0) {
                    return d;
                }
                Class<?> c1 = f1.getDeclaringClass();
                Class<?> c2 = f2.getDeclaringClass();
                return c1.getName().compareTo(c2.getName());
            }
        });
        AccessibleObject.setAccessible(fields, true);
        fieldsForType.put(obj.getClass(), (Field[])fields);
        return fields;
    }

    public static String toString(Color c) {
        return "#" + Integer.toHexString(c.getRGB()) + "/" + Integer.toHexString(c.getAlpha());
    }
}

