#! /bin/sh

# Optional: Use a specific Java installation
#JAVA_HOME=/usr/lib/jvm/java-7-openjdk

# Optional: Specify the amount of RAM to use (here 120 MB) or other Java options
#JAVA_OPTS=-Xmx120m

# Change to this script's directory to run the Java version tester
ORG_DIR=`pwd`
APP_DIR=`dirname $0`
cd $APP_DIR

# Detect Java executable according to the following algorithm:
#
# 1. If $JRE_HOME is a valid JRE path, use it
# 2. If $JAVA_HOME is a valid JRE path, use it
# 3. If $JAVA_HOME is a valid JDK path, use it
# 4. Assume 'java' is in the command path

if [ -d "$JRE_HOME" -a -x "$JRE_HOME/bin/java" ]; then
	JAVACMD="$JRE_HOME/bin/java"
elif [ -d "$JAVA_HOME" -a -x "$JAVA_HOME/bin/java" ]; then
	JAVACMD="$JAVA_HOME/bin/java"
elif [ -d "$JAVA_HOME" -a -x "$JAVA_HOME/jre/bin/java" ]; then
	JAVACMD="$JAVA_HOME/jre/bin/java"
else
	JAVACMD=java
fi

# Detect:
# 1. If a >=1.6 server JVM is available, and use it if it is the case
# 2. If a >=1.6 JVM is available, and use it if it is the case
# 2. If Java version >= 1.5 is available. If not, display an error

cd ./data
# Try server VM, 1.6:
"$JAVACMD" -server javatester.TestJava 1.6 2> /dev/null
if [ "$?" = "0" ]; then
  # Server VM found, use it
  JOPTS=-server
else
  # Try default VM, 1.6
  "$JAVACMD" javatester.TestJava 1.6 2> /dev/null
  if [ "$?" = "0" ]; then
    JOPTS=
  else
    # Try default VM, 1.5
    "$JAVACMD" javatester.TestJava 1.5 2> /dev/null
    if [ "$?" != "0" ]; then
      echo "Cannot find a suitable Java Runtime Environment (JRE)."
      echo "This application requires Java version 5 or greater (version 6 recommanded)."
      echo "Please install the latest version of Java and try again."
    exit;
  fi
    JOPTS=
    echo "Running with Java version 5."
    echo "For best results, upgrading to Java 6 or greater is recommanded."
  fi
fi

# Go back to original dir in case arguments are relative paths
cd $ORG_DIR

# Invoke application
$JAVACMD $JOPTS $JAVA_OPTS -jar $APP_DIR/data/Tachyon-Sonics.jar "$@"
