/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.integration;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.desktop.QuitStrategy;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.corebounce.common.os.ApplicationDetails;
import org.corebounce.common.os.Integrator;
import org.corebounce.common.utils.Platform;

public class IntegratorImpl
implements Integrator {
    @Override
    public void integrate(ApplicationDetails appDetail) {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        assert (SwingUtilities.isEventDispatchThread());
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
            desktop.setAboutHandler(e -> appDetail.getAboutAction().actionPerformed(null));
            this.removeMenuItemIfReplaced(appDetail.getAboutMenuItem());
        }
        if (desktop.isSupported(Desktop.Action.APP_PREFERENCES)) {
            desktop.setPreferencesHandler(e -> appDetail.getPreferenceAction().actionPerformed(null));
            this.removeMenuItemIfReplaced(appDetail.getPreferenceMenuItem());
        }
        if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
            desktop.setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
            desktop.setQuitHandler((e, response) -> {
                Boolean accepted = appDetail.handleQuit();
                if (Boolean.FALSE.equals(accepted)) {
                    response.cancelQuit();
                } else {
                    response.performQuit();
                }
            });
            this.removeMenuItemIfReplaced(appDetail.getQuitMenuItem());
        }
        if (desktop.isSupported(Desktop.Action.APP_OPEN_FILE)) {
            desktop.setOpenFileHandler(e -> {
                for (File file : e.getFiles()) {
                    appDetail.handleOpenFile(file);
                }
            });
        }
    }

    private void removeMenuItemIfReplaced(JMenuItem menuItem) {
        if (menuItem == null) {
            return;
        }
        if (!Platform.isMacOsX()) {
            return;
        }
        Container parent = menuItem.getParent();
        int index = 0;
        Component[] children = parent.getComponents();
        int i = 0;
        while (i < children.length) {
            if (children[i] == menuItem) {
                index = i;
            }
            ++i;
        }
        parent.remove(index);
        if (index > 0 && children[index - 1] instanceof JSeparator) {
            parent.remove(index - 1);
        }
    }

    @Override
    public void setModifiedStatus(JFrame window, boolean modified) {
        SwingUtilities.invokeLater(() -> window.getRootPane().putClientProperty("Window.documentModified", modified));
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        if (desktop.isSupported(Desktop.Action.APP_SUDDEN_TERMINATION)) {
            if (modified) {
                desktop.disableSuddenTermination();
            } else {
                desktop.enableSuddenTermination();
            }
        }
    }

    @Override
    public String getExecutablePath() {
        return ProcessHandle.current().info().command().orElse(null);
    }
}

