/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img;

import ch.tachyon.sonics.snd2img.NoiseDot;
import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.VideoResolutionType;
import java.util.Random;

public class FrameRenderer {
    private static final int PDIM = 3;
    static final int NB_NOISE = 150;
    private static final double NOISE_RADIUS = 0.01;
    private final SoundFeaturesBlackboard blackboard;
    private final int width;
    private final int height;
    private byte[] frameBuffer;
    private NoiseDot[] commonNoiseDots;
    private NoiseDot[] myNoiseDots;
    private double beatLevelLow;
    private double beatLevelMid;
    private double beatLevelHigh;
    private double noiseRed;
    private double noiseGreen;
    private double noiseBlue;
    private double[] notesLevel = new double[24];
    private double[] notesLevelLow = new double[24];
    private double[] notesLevelMid = new double[24];
    private double[] notesLevelHigh = new double[24];
    private final Random rnd = new Random(0L);

    public FrameRenderer(SoundFeaturesBlackboard blackboard, VideoResolutionType resolution) {
        this(blackboard, resolution, new NoiseDot[150]);
    }

    public FrameRenderer(SoundFeaturesBlackboard blackboard, VideoResolutionType resolution, NoiseDot[] noiseDots) {
        this.blackboard = blackboard;
        this.width = resolution.getWidth();
        this.height = resolution.getHeight();
        this.frameBuffer = new byte[this.width * this.height * 3];
        this.commonNoiseDots = noiseDots;
        this.myNoiseDots = new NoiseDot[150];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getNextFrame() {
        this.pickSoundFeatures();
        this.processNoiseDots();
        return this.renderFrame();
    }

    void pickSoundFeatures() {
        this.beatLevelLow = this.blackboard.readBeatLevel(0);
        this.beatLevelMid = this.blackboard.readBeatLevel(1);
        this.beatLevelHigh = this.blackboard.readBeatLevel(2);
        this.beatLevelHigh *= 0.75;
        int i = 0;
        while (i < this.notesLevel.length) {
            this.notesLevel[i] = this.blackboard.readSinesNote(i);
            this.notesLevelLow[i] = this.blackboard.readSinesNoteLow(i);
            this.notesLevelMid[i] = this.blackboard.readSinesNoteMid(i);
            this.notesLevelHigh[i] = this.blackboard.readSinesNoteHigh(i);
            int n = i;
            this.notesLevelLow[n] = this.notesLevelLow[n] * this.notesLevelLow[i];
            int n2 = i;
            this.notesLevelMid[n2] = this.notesLevelMid[n2] * this.notesLevelMid[i];
            int n3 = i;
            this.notesLevelHigh[n3] = this.notesLevelHigh[n3] * this.notesLevelHigh[i];
            ++i;
        }
        this.noiseRed = this.blackboard.readNoiseRed();
        this.noiseGreen = this.blackboard.readNoiseGreen();
        this.noiseBlue = this.blackboard.readNoiseBlue();
    }

    void processNoiseDots() {
        double noiseLevel = Math.sqrt((this.noiseRed * this.noiseRed + this.noiseGreen * this.noiseGreen + this.noiseBlue * this.noiseBlue) / 3.0);
        this.noiseRed = this.crop(this.noiseRed / noiseLevel);
        this.noiseGreen = this.crop(this.noiseGreen / noiseLevel);
        this.noiseBlue = this.crop(this.noiseBlue / noiseLevel);
        noiseLevel *= 1.7;
        noiseLevel = (noiseLevel *= noiseLevel) > 0.8 ? 1.0 : (noiseLevel < 0.2 ? 0.0 : (noiseLevel - 0.2) / 0.6);
        int dim = (this.width + this.height) / 2;
        int nbNoise = (int)(noiseLevel * 150.0);
        int i = 0;
        while (i < 150) {
            if (i < nbNoise && (this.commonNoiseDots[i] == null || this.commonNoiseDots[i].alpha <= 0.0)) {
                int px = this.rnd.nextInt(this.width);
                int py = this.rnd.nextInt(this.height);
                int radius = (int)(0.01 * (double)dim * (double)i / 150.0);
                this.commonNoiseDots[i] = this.commonNoiseDots[i] == null ? new NoiseDot(px, py, radius, this.rnd.nextDouble() * 2.0) : new NoiseDot(px, py, radius, this.rnd.nextDouble() + 1.0);
            }
            if (this.commonNoiseDots[i] != null && this.commonNoiseDots[i].alpha > 0.0) {
                this.commonNoiseDots[i].decay();
            }
            this.myNoiseDots[i] = this.commonNoiseDots[i] != null ? this.commonNoiseDots[i].clone() : null;
            ++i;
        }
    }

    byte[] renderFrame() {
        double centerX = (double)this.width / 2.0;
        double centerY = (double)this.height / 2.0;
        double attenuationStart = (double)Math.max(this.width, this.height) * 0.4;
        double attenuationStop = (double)Math.max(this.width, this.height) * 0.5;
        double maxDist = Math.sqrt(centerX * centerY * 2.0);
        int y = 0;
        while (y < this.height) {
            int x = 0;
            while (x < this.width) {
                double cx = (double)x - centerX;
                double cy = (double)y - centerY;
                double distance = Math.sqrt(cx * cx + cy * cy);
                double attenuation = 1.0;
                if (distance > attenuationStart) {
                    attenuation = distance < attenuationStop ? (attenuationStop - distance) / (attenuationStop - attenuationStart) : 0.0;
                }
                distance = distance * 24.0 * 2.0 / maxDist;
                double noteLevelLow = this.pickInterpolatedLevel(this.notesLevelLow, distance);
                double noteLevelMid = this.pickInterpolatedLevel(this.notesLevelMid, distance);
                double noteLevelHigh = this.pickInterpolatedLevel(this.notesLevelHigh, distance);
                double beatBoost = 0.7;
                double bLevelLow = this.beatLevelLow * beatBoost;
                double bLevelMid = this.beatLevelMid * beatBoost;
                double bLevelHigh = this.beatLevelHigh * beatBoost;
                double red = noteLevelLow + bLevelLow;
                double green = noteLevelMid + bLevelMid;
                double blue = noteLevelHigh + bLevelHigh;
                double saturation = 0.0;
                if (red > 1.0) {
                    saturation += red - 1.0;
                    red = 1.0;
                }
                if (green > 1.0) {
                    saturation += green - 1.0;
                    green = 1.0;
                }
                if (blue > 1.0) {
                    saturation += blue - 1.0;
                    blue = 1.0;
                }
                red = this.crop(red + saturation);
                green = this.crop(green + saturation);
                blue = this.crop(blue + saturation);
                byte valueRed = (byte)((red *= attenuation) * 255.0);
                byte valueGreen = (byte)((green *= attenuation) * 255.0);
                byte valueBlue = (byte)((blue *= attenuation) * 255.0);
                int offset = (y * this.width + x) * 3;
                this.frameBuffer[offset + 0] = valueRed;
                this.frameBuffer[offset + 1] = valueGreen;
                this.frameBuffer[offset + 2] = valueBlue;
                ++x;
            }
            ++y;
        }
        int i = 0;
        while (i < 150) {
            if (this.myNoiseDots[i] != null && this.myNoiseDots[i].alpha > 0.0) {
                int px = this.myNoiseDots[i].px;
                int py = this.myNoiseDots[i].py;
                int radius = this.myNoiseDots[i].radius;
                double cx = (double)px - centerX;
                double cy = (double)py - centerY;
                double distance = Math.sqrt(cx * cx + cy * cy);
                double attenuation = 1.0;
                if (distance > attenuationStart) {
                    attenuation = distance < attenuationStop ? (attenuationStop - distance) / (attenuationStop - attenuationStart) : 0.0;
                }
                int y2 = py - radius;
                while (y2 <= py + radius) {
                    int x = px - radius;
                    while (x <= px + radius) {
                        if (x >= 0 && y2 >= 0 && x < this.width && y2 < this.height) {
                            int dx = x - px;
                            int dy = y2 - py;
                            double distanceC = Math.sqrt(dx * dx + dy * dy);
                            double attenuationC = this.crop(1.0 - distanceC / (double)(radius + 1));
                            this.compose(x, y2, this.noiseRed, this.noiseGreen, this.noiseBlue, attenuation * attenuationC * this.crop(this.myNoiseDots[i].alpha));
                        }
                        ++x;
                    }
                    ++y2;
                }
            }
            ++i;
        }
        return this.frameBuffer;
    }

    private double pickInterpolatedLevel(double[] levels, double index) {
        int index0 = (int)index;
        int index1 = index0 + 1;
        double w1 = index - (double)index0;
        double w0 = 1.0 - w1;
        w0 = Math.sqrt(w0);
        w1 = Math.sqrt(w1);
        return this.pickLevel(levels, index0) * w0 + this.pickLevel(levels, index1) * w1;
    }

    private double pickLevel(double[] levels, int index) {
        if (index < 0) {
            return 0.0;
        }
        return levels[index % levels.length];
    }

    private double crop(double value) {
        if (value < 0.0) {
            return 0.0;
        }
        if (value > 1.0) {
            return 1.0;
        }
        return value;
    }

    private void compose(int x, int y, double red, double green, double blue, double alpha) {
        int offset = (y * this.width + x) * 3;
        int iRed = this.frameBuffer[offset + 0] & 0xFF;
        int iGreen = this.frameBuffer[offset + 1] & 0xFF;
        int iBlue = this.frameBuffer[offset + 2] & 0xFF;
        double sRed = (double)iRed / 255.0;
        double sGreen = (double)iGreen / 255.0;
        double sBlue = (double)iBlue / 255.0;
        double dRed = sRed * (1.0 - alpha) + red * alpha;
        double dGreen = sGreen * (1.0 - alpha) + green * alpha;
        double dBlue = sBlue * (1.0 - alpha) + blue * alpha;
        iRed = this.crop((int)(dRed * 255.0));
        iGreen = this.crop((int)(dGreen * 255.0));
        iBlue = this.crop((int)(dBlue * 255.0));
        this.frameBuffer[offset + 0] = (byte)iRed;
        this.frameBuffer[offset + 1] = (byte)iGreen;
        this.frameBuffer[offset + 2] = (byte)iBlue;
    }

    private int crop(int value) {
        if (value < 0) {
            value = 0;
        } else if (value > 255) {
            value = 255;
        }
        return value;
    }
}

