/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img;

import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.audio.AutoGain;
import ch.tachyon.sonics.snd2img.audio.DCRemove;
import ch.tachyon.sonics.snd2img.audio.StnAnalyser;

public class SoundAnalyser {
    private static final int SAMPLE_RATE = 48000;
    private DCRemove dcRemove;
    private AutoGain autoGain;
    private StnAnalyser stnAnalyser;
    private int audioFrameSize;
    private int analyserFrameSize = 32;
    private float[] audioBufferMono;
    private float[] analysisBuffer;

    public SoundAnalyser(SoundFeaturesBlackboard blackboard) {
        int sampleRate = 48000;
        String value = System.getProperty("AudioSampleRate");
        if (value != null) {
            try {
                sampleRate = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        this.dcRemove = new DCRemove();
        this.autoGain = new AutoGain();
        this.stnAnalyser = new StnAnalyser(sampleRate, blackboard);
        if (this.audioFrameSize < this.analyserFrameSize) {
            this.audioFrameSize = this.analyserFrameSize;
        }
        assert (this.audioFrameSize >= this.analyserFrameSize);
        this.audioBufferMono = new float[this.audioFrameSize];
        this.analysisBuffer = new float[this.analyserFrameSize];
    }

    public int getAnalyserFrameSize() {
        return this.analyserFrameSize;
    }

    public void analyze(float[][] buffer) {
        this.toMono(buffer, this.audioBufferMono);
        int offset = 0;
        while (offset < this.audioBufferMono.length) {
            System.arraycopy(this.audioBufferMono, offset, this.analysisBuffer, 0, this.analyserFrameSize);
            this.dcRemove.process(this.analysisBuffer);
            this.autoGain.process(this.analysisBuffer);
            this.stnAnalyser.process(this.analysisBuffer, this.analysisBuffer);
            System.arraycopy(this.analysisBuffer, 0, this.audioBufferMono, offset, this.analyserFrameSize);
            offset += this.analyserFrameSize;
        }
    }

    private void toMono(float[][] audioBufferMulti, float[] audioBufferMono) {
        System.arraycopy(audioBufferMulti[0], 0, audioBufferMono, 0, this.audioFrameSize);
        int chan = 1;
        while (chan < audioBufferMulti.length) {
            int i = 0;
            while (i < this.audioFrameSize) {
                int n = i;
                audioBufferMono[n] = audioBufferMono[n] + audioBufferMulti[chan][i];
                ++i;
            }
            ++chan;
        }
    }
}

