/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img;

public class SoundFeaturesBlackboard {
    private static final double DECAY_BEAT = 0.5;
    private static final double DECAY_NOISE = 0.7;
    private static final double DECAY_NOTES = 0.8;
    public static final int RANGE_DIVISIONS = 24;
    public static final int NB_LEVELS = 3;
    public static final int LOW_INDEX = 0;
    public static final int MID_INDEX = 1;
    public static final int HIGH_INDEX = 2;
    private double[] beatLevels = new double[3];
    private final Object noiseLock = new Object();
    private double noiseRed;
    private double noiseGreen;
    private double noiseBlue;
    private double[] sinesNotes = new double[24];
    private double[] sinesNotesLow = new double[24];
    private double[] sinesNotesMid = new double[24];
    private double[] sinesNotesHigh = new double[24];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBeatLevel(int rangeIndex, double value) {
        double[] dArray = this.beatLevels;
        synchronized (this.beatLevels) {
            if (value > this.beatLevels[rangeIndex]) {
                this.beatLevels[rangeIndex] = value;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readBeatLevel(int rangeIndex) {
        double[] dArray = this.beatLevels;
        synchronized (this.beatLevels) {
            double result = this.beatLevels[rangeIndex];
            int n = rangeIndex;
            this.beatLevels[n] = this.beatLevels[n] * 0.5;
            if (result > 1.0) {
                result = 1.0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readNoiseRed() {
        Object object = this.noiseLock;
        synchronized (object) {
            double result = this.noiseRed;
            this.noiseRed *= 0.7;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNoiseRed(double noiseRed) {
        Object object = this.noiseLock;
        synchronized (object) {
            if (noiseRed > this.noiseRed) {
                this.noiseRed = noiseRed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readNoiseGreen() {
        Object object = this.noiseLock;
        synchronized (object) {
            double result = this.noiseGreen;
            this.noiseGreen *= 0.7;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNoiseGreen(double noiseGreen) {
        Object object = this.noiseLock;
        synchronized (object) {
            if (noiseGreen > this.noiseGreen) {
                this.noiseGreen = noiseGreen;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double readNoiseBlue() {
        Object object = this.noiseLock;
        synchronized (object) {
            double result = this.noiseBlue;
            this.noiseBlue *= 0.7;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeNoiseBlue(double noiseBlue) {
        Object object = this.noiseLock;
        synchronized (object) {
            if (noiseBlue > this.noiseBlue) {
                this.noiseBlue = noiseBlue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNote(double[] notes, int index, double value) {
        double[] dArray = notes;
        synchronized (notes) {
            if (value > notes[index]) {
                notes[index] = value;
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double readNote(double[] notes, int index) {
        double[] dArray = notes;
        synchronized (notes) {
            double result = notes[index];
            int n = index;
            notes[n] = notes[n] * 0.8;
            if (result > 1.0) {
                result = 1.0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public void writeSinesNote(int index, double value) {
        this.writeNote(this.sinesNotes, index, value);
    }

    public double readSinesNote(int index) {
        return this.readNote(this.sinesNotes, index);
    }

    public void writeSinesNoteLow(int index, double value) {
        this.writeNote(this.sinesNotesLow, index, value);
    }

    public double readSinesNoteLow(int index) {
        return this.readNote(this.sinesNotesLow, index);
    }

    public void writeSinesNoteMid(int index, double value) {
        this.writeNote(this.sinesNotesMid, index, value);
    }

    public double readSinesNoteMid(int index) {
        return this.readNote(this.sinesNotesMid, index);
    }

    public void writeSinesNoteHigh(int index, double value) {
        this.writeNote(this.sinesNotesHigh, index, value);
    }

    public double readSinesNoteHigh(int index) {
        return this.readNote(this.sinesNotesHigh, index);
    }
}

