/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img;

import ch.tachyon.sonics.snd2img.SoundToImageConverter;
import ch.tachyon.sonics.snd2img.VideoResolutionType;
import ch.tachyon.sonics.snd2img.gui.SoundToImageFrame;
import ch.tachyon.sonics.snd2img.utils.ConsoleProgressMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;

public class SoundToImage {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            SwingUtilities.invokeLater(SoundToImage::processGui);
        } else {
            SoundToImage.processCommandLine(args);
        }
    }

    private static void processCommandLine(String[] args) throws Exception {
        File outputVideoFile;
        String resStr;
        File inputAudioFile;
        if (args.length < 2) {
            SoundToImage.dumpUsageAndExit();
        }
        if (!(inputAudioFile = new File(args[0])).isFile()) {
            System.out.println("File not found: " + args[0]);
            System.exit(1);
        }
        VideoResolutionType resolution = VideoResolutionType.P_480;
        if (args.length >= 4 && args[1].equals("-s") && (resolution = VideoResolutionType.fromString(resStr = args[2])) == null) {
            System.err.println("Unsupported resolution: " + resStr);
            System.err.println("Possible values: " + SoundToImage.getSizeValues());
            System.exit(1);
        }
        if ((outputVideoFile = new File(args[args.length - 1])).isDirectory()) {
            System.out.println("Output file is a directory: " + args[args.length - 1]);
            System.exit(1);
        }
        if (outputVideoFile.isFile()) {
            System.out.print("Output file \"" + args[args.length - 1] + "\" already exists. Replace it [y/n]? ");
            System.out.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String response = reader.readLine();
            if (!response.toLowerCase().startsWith("y")) {
                System.exit(0);
            }
        }
        System.out.println("Input audio file: " + inputAudioFile);
        System.out.println("Output video file: " + outputVideoFile);
        System.out.println("Video resolution: " + resolution.toString());
        try (SoundToImageConverter converter = new SoundToImageConverter(inputAudioFile, resolution, outputVideoFile);){
            converter.process(new ConsoleProgressMonitor());
        }
    }

    private static void dumpUsageAndExit() {
        System.out.println("Usage: snd2img <input audio file> [options] <output video file>");
        System.out.println("  <input audio file>: supported formats .wav, .aiff, .au, .flac, .ogg, .mp3, .m4a, .opus");
        System.out.println("  <output video file>: only .mkv format is supported");
        System.out.println("Options:");
        System.out.println("  -s <size>: specify video size");
        String sizes = SoundToImage.getSizeValues();
        System.out.println("  Possible values for <size>: " + sizes);
        System.exit(1);
    }

    private static String getSizeValues() {
        StringBuilder sizes = new StringBuilder();
        VideoResolutionType[] videoResolutionTypeArray = VideoResolutionType.values();
        int n = videoResolutionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VideoResolutionType resolution = videoResolutionTypeArray[n2];
            if (sizes.length() > 0) {
                sizes.append(", ");
            }
            sizes.append(resolution.toCommandLineString());
            ++n2;
        }
        return sizes.toString();
    }

    private static void processGui() {
        AwtTools.switchToNativeLookAndFeel();
        SoundToImageFrame frame = new SoundToImageFrame();
        frame.setVisible(true);
    }
}

