/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img;

import ch.tachyon.sonics.snd2img.SoundAnalyser;
import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.SoundToImageEngine;
import ch.tachyon.sonics.snd2img.VideoResolutionType;
import ch.tachyon.sonics.snd2img.utils.FFmpeg;
import ch.tachyon.tunnel.audio.file.AudioFileIO;
import ch.tachyon.tunnel.audio.file.AudioFileTypes;
import ch.tachyon.tunnel.audio.utils.IProgressMonitor;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import org.corebounce.common.utils.StringUtils;

public class SoundToImageConverter {
    public static final int FPS = 25;
    private final File inputAudioFile;
    private final VideoResolutionType resolution;
    private final OutputStream framesOutputStream;
    private FFmpeg ffmpeg;
    private double time = 0.0;
    private double nextImageFrameTime = 0.0;

    public SoundToImageConverter(File inputAudioFile, VideoResolutionType resolution, OutputStream framesOutputStream) {
        this.inputAudioFile = inputAudioFile;
        this.resolution = resolution;
        this.framesOutputStream = framesOutputStream;
    }

    public SoundToImageConverter(File inputAudioFile, VideoResolutionType resolution, File outputVideoFile) throws IOException {
        this.inputAudioFile = inputAudioFile;
        this.resolution = resolution;
        if (outputVideoFile.isFile()) {
            Files.delete(outputVideoFile.toPath());
        }
        this.ffmpeg = new FFmpeg();
        OutputStream ffOutput = this.ffmpeg.createFfmpegCommand(FFmpeg.getFfmpegPath(), inputAudioFile, outputVideoFile, resolution);
        this.framesOutputStream = new BufferedOutputStream(ffOutput);
    }

    public void process(IProgressMonitor progress) throws Exception {
        AudioFileFormat inputFormat = AudioFileTypes.instance().getAudioFileFormat(this.inputAudioFile, true);
        double duration = (double)inputFormat.getFrameLength() / (double)inputFormat.getFormat().getSampleRate();
        double sampleRate = inputFormat.getFormat().getSampleRate();
        if (sampleRate < 44000.0 || sampleRate > 50000.0) {
            throw new IllegalArgumentException(StringUtils.format("Unsupported sample rate {0} Hz. Must be 44.1 kHz or 48 kHz", (int)sampleRate));
        }
        SoundFeaturesBlackboard blackboard = new SoundFeaturesBlackboard();
        SoundAnalyser soundAnalyzer = new SoundAnalyser(blackboard);
        SoundToImageEngine engine = new SoundToImageEngine(blackboard, this.resolution, this.framesOutputStream);
        IMultiChanAudioSource audioSource = AudioFileIO.createAudioSource(this.inputAudioFile);
        int nbChans = audioSource.getAudioFormat().getChannels();
        int bufferSize = soundAnalyzer.getAnalyserFrameSize();
        float[][] audioBuffer = new float[nbChans][bufferSize];
        this.time = 0.0;
        this.nextImageFrameTime = 0.04;
        try {
            progress.setProgress(0.0, duration);
            int read = audioSource.readSamples(audioBuffer);
            while (read > 0) {
                if (read < bufferSize) {
                    SoundToImageConverter.zeroPadFrom(read, audioBuffer);
                }
                soundAnalyzer.analyze(audioBuffer);
                this.time += (double)read / sampleRate;
                if (this.time >= this.nextImageFrameTime) {
                    engine.processNextFrame();
                    this.nextImageFrameTime += 0.04;
                }
                progress.setProgress(this.time, duration);
                read = audioSource.readSamples(audioBuffer);
            }
            progress.setProgress(duration, duration);
        }
        finally {
            engine.finish();
            audioSource.close();
            if (this.ffmpeg != null) {
                this.framesOutputStream.flush();
                this.framesOutputStream.close();
                this.ffmpeg.waitFor();
                this.ffmpeg = null;
            }
        }
    }

    private static void zeroPadFrom(int offset, float[][] buffer) {
        int chan = 0;
        while (chan < buffer.length) {
            Arrays.fill(buffer[chan], offset, buffer[chan].length, 0.0f);
            ++chan;
        }
    }

    public void close() throws IOException {
        if (this.framesOutputStream != null) {
            this.framesOutputStream.close();
        }
    }
}

