/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img;

import ch.tachyon.sonics.snd2img.FrameRenderer;
import ch.tachyon.sonics.snd2img.NoiseDot;
import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.VideoResolutionType;
import ch.tachyon.sonics.snd2img.utils.ImageUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class SoundToImageEngine {
    private final OutputStream framesOutputStream;
    private final NoiseDot[] noiseDots;
    private ExecutorService pool;
    private BlockingQueue<FrameRenderer> renderersQueue;
    private BlockingQueue<Future<byte[]>> imagesQueue;
    private Thread collectorThread;
    private AtomicReference<Exception> exRef = new AtomicReference();

    public SoundToImageEngine(SoundFeaturesBlackboard blackboard, VideoResolutionType resolution, OutputStream framesOutputStream) {
        this(blackboard, resolution, framesOutputStream, Math.max(1, Runtime.getRuntime().availableProcessors() - 1));
    }

    public SoundToImageEngine(SoundFeaturesBlackboard blackboard, VideoResolutionType resolution, OutputStream framesOutputStream, int nbThreads) {
        this.framesOutputStream = framesOutputStream;
        this.noiseDots = new NoiseDot[150];
        this.renderersQueue = new ArrayBlockingQueue<FrameRenderer>(nbThreads);
        int i = 0;
        while (i < nbThreads) {
            this.renderersQueue.add(new FrameRenderer(blackboard, resolution, this.noiseDots));
            ++i;
        }
        this.imagesQueue = new ArrayBlockingQueue<Future<byte[]>>(nbThreads, true);
        this.pool = Executors.newFixedThreadPool(nbThreads);
        this.collectorThread = new Thread(this::collectLoop, "Images Collector");
        this.collectorThread.setDaemon(true);
        this.collectorThread.start();
    }

    public void processNextFrame() throws Exception {
        FrameRenderer frameRenderer = this.renderersQueue.take();
        frameRenderer.pickSoundFeatures();
        frameRenderer.processNoiseDots();
        FutureTask<byte[]> task = new FutureTask<byte[]>(() -> {
            Thread.currentThread().setPriority(1);
            byte[] result = SoundToImageEngine.renderFrame(frameRenderer);
            this.renderersQueue.add(frameRenderer);
            return result;
        });
        this.pool.submit(task);
        this.imagesQueue.put(task);
        if (this.exRef.get() != null) {
            throw (Exception)this.exRef.getAndSet(null);
        }
    }

    private static byte[] renderFrame(FrameRenderer frameRenderer) throws IOException, InterruptedException {
        byte[] frameBuffer = frameRenderer.renderFrame();
        BufferedImage frameImage = ImageUtils.byteArrayToImage(frameBuffer, frameRenderer.getWidth(), frameRenderer.getHeight());
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageUtils.saveImage(frameImage, output);
        output.flush();
        output.close();
        return output.toByteArray();
    }

    private void collectLoop() {
        while (true) {
            try {
                while (true) {
                    byte[] imageData = this.imagesQueue.take().get();
                    this.framesOutputStream.write(imageData);
                }
            }
            catch (IOException | InterruptedException | ExecutionException ex) {
                this.exRef.set(ex);
                continue;
            }
            break;
        }
    }

    public void finish() throws InterruptedException {
        this.pool.shutdown();
        this.pool.awaitTermination(10L, TimeUnit.SECONDS);
    }
}

