/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img;

public enum VideoResolutionType {
    P_360(640, 360, 5000),
    P_480(854, 480, 7500),
    P_720(1280, 720, 10000),
    P_1080(1920, 1080, 16000),
    P_2160(3840, 2160, 40000);

    private final int width;
    private final int height;
    private final int kBps;

    private VideoResolutionType(int width, int height, int kBps) {
        this.width = width;
        this.height = height;
        this.kBps = kBps;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getkBps() {
        return this.kBps;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(String.valueOf(this.height)) + "p");
        result.append(" (");
        result.append(String.valueOf(this.width));
        result.append("x");
        result.append(String.valueOf(this.height));
        result.append(")");
        return result.toString();
    }

    public String toCommandLineString() {
        return String.valueOf(String.valueOf(this.width)) + "x" + String.valueOf(this.height);
    }

    public static VideoResolutionType fromString(String str) {
        VideoResolutionType[] videoResolutionTypeArray = VideoResolutionType.values();
        int n = videoResolutionTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            VideoResolutionType r = videoResolutionTypeArray[n2];
            String full = r.toCommandLineString();
            String width = String.valueOf(r.width);
            String height = String.valueOf(r.height);
            if (str.equals(full) || str.equals(width) || str.equals(height) || str.equals(String.valueOf(height) + "p")) {
                return r;
            }
            ++n2;
        }
        return null;
    }
}

