/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio;

import ch.tachyon.sonics.snd2img.audio.AutoGainEngine;
import ch.tachyon.sonics.snd2img.dsp.AudioMath;

public class AutoGain {
    private static final double MAX2AVG = 0.25;
    private static final double SAMPLE_RATE = 48000.0;
    private static final double SMOOTH_DELAY = 0.05;
    private static final double MIN_LEVEL = AudioMath.dbToLevel(-20.0);
    private static final double ATTACK_FACTOR = AudioMath.dbToLevel(0.0125);
    private static final double SUSTAIN_TIME = 2.0;
    private static final double DECAY_FACTOR = AudioMath.dbToLevel(-1.25E-4);
    private static final double ACCURACY = AudioMath.dbToLevel(1.0);
    private static final double TARGET_UPPER = AudioMath.dbToLevel(-3.0);
    private static final double TARGET_LOWER = TARGET_UPPER / ACCURACY;
    private AutoGainEngine gainEngine;

    public AutoGain() {
        int historySize = 2400;
        int sustainSpeed = 96000;
        this.gainEngine = new AutoGainEngine(historySize, sustainSpeed, ATTACK_FACTOR, DECAY_FACTOR, MIN_LEVEL);
    }

    public void process(float[] data) {
        double thresholdLevel = MIN_LEVEL * 0.25;
        this.gainEngine.process(data);
        double gain = this.gainEngine.getGain();
        if (gain < thresholdLevel) {
            gain = thresholdLevel;
        }
        float correction = 1.0f;
        if (gain < TARGET_LOWER) {
            correction = (float)(TARGET_LOWER / gain);
        } else if (gain > TARGET_UPPER) {
            correction = (float)(gain / TARGET_UPPER);
        }
        int i = 0;
        while (i < data.length) {
            data[i] = data[i] * correction;
            ++i;
        }
    }
}

