/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio;

import ch.tachyon.sonics.snd2img.dsp.AudioMath;
import ch.tachyon.sonics.snd2img.dsp.AverageBuffer;

public class AutoGainEngine {
    private static final double MIN_LEVEL = AudioMath.dbToLevel(-100.0);
    private final AverageBuffer history;
    private int sustainSpeed;
    private double attackSpeed;
    private double decaySpeed;
    private double smoothedGain;
    private int sustainCountDown;
    private double jumpLevel;

    public AutoGainEngine(int historySize, int sustainSpeed, double attackSpeed, double decaySpeed, double jumpLevel) {
        this.history = new AverageBuffer(historySize);
        this.setSustainSpeed(sustainSpeed);
        this.setAttackSpeed(attackSpeed);
        this.setDecaySpeed(decaySpeed);
        this.setJumpLevel(jumpLevel);
        this.smoothedGain = MIN_LEVEL;
    }

    public int getSustainSpeed() {
        return this.sustainSpeed;
    }

    public void setSustainSpeed(int sustainSpeed) {
        this.sustainSpeed = sustainSpeed;
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    public double getJumpLevel() {
        return this.jumpLevel;
    }

    public void setJumpLevel(double jumpLevel) {
        this.jumpLevel = jumpLevel;
    }

    public void setAttackSpeed(double attackSpeed) {
        this.attackSpeed = attackSpeed;
    }

    public double getDecaySpeed() {
        return this.decaySpeed;
    }

    public void setDecaySpeed(double decaySpeed) {
        this.decaySpeed = decaySpeed;
    }

    public void process(float[] samples) {
        int i = 0;
        while (i < samples.length) {
            this.history.push(samples[i] * samples[i]);
            double immediateGain = Math.sqrt(this.history.getAverage());
            if (immediateGain >= this.smoothedGain) {
                this.smoothedGain = this.smoothedGain < this.jumpLevel ? immediateGain : (this.smoothedGain *= this.attackSpeed);
                if (this.smoothedGain > immediateGain) {
                    this.smoothedGain = immediateGain;
                }
                this.sustainCountDown = this.sustainSpeed;
            } else if (this.sustainCountDown > 0) {
                --this.sustainCountDown;
            } else {
                this.smoothedGain *= this.decaySpeed;
                if (this.smoothedGain < MIN_LEVEL) {
                    this.smoothedGain = MIN_LEVEL;
                }
                if (this.smoothedGain < immediateGain) {
                    this.smoothedGain = immediateGain;
                }
            }
            ++i;
        }
    }

    public double getGain() {
        return this.smoothedGain;
    }
}

