/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio;

import ch.tachyon.sonics.snd2img.audio.BeatExtractEngine;
import ch.tachyon.sonics.snd2img.audio.StftEngine;
import ch.tachyon.sonics.snd2img.audio.StftSynthesisBuffer;
import ch.tachyon.sonics.snd2img.dsp.AudioMath;
import ch.tachyon.sonics.snd2img.dsp.Cmplx;
import java.util.Arrays;

public class BeatExtract
extends StftEngine {
    private static final int MIN_LENGTH = 138;
    private static final int AVG_LENGTH = 41;
    private static final double SENSIVITY = 5.0;
    private static final double ATTACK_SPEED = 15.0;
    private static final int MIN_SPAN = 20;
    private static final float CEIL_LEVEL = 10.0f;
    public static final int BLOCK_SIZE = 128;
    public static final int HOP_SIZE = 32;
    private final BeatExtractEngine engine;
    private final float[] attackLevels;
    private final StftSynthesisBuffer beatBuffer;
    private final StftSynthesisBuffer restBuffer;
    private final Cmplx[] beatSpectrum;
    private final Cmplx[] restSpectrum;

    public BeatExtract() {
        super(128, 32);
        this.engine = new BeatExtractEngine(this.nbBins, 138, 41);
        this.attackLevels = new float[this.nbBins];
        Arrays.fill(this.attackLevels, (float)AudioMath.dbToLevel(-100.0));
        this.beatBuffer = new StftSynthesisBuffer(128, 32);
        this.restBuffer = new StftSynthesisBuffer(128, 32);
        this.beatSpectrum = Cmplx.newArray(this.nbBins);
        this.restSpectrum = Cmplx.newArray(this.nbBins);
    }

    public void process(float[] input, float[] outBeat, float[] outRest) {
        this.analyse(input, 0, input.length);
        this.process();
        this.callAnalysers(this.beatSpectrum);
        this.synthesize(this.restBuffer, this.restSpectrum, outRest, 0, outRest.length);
        this.synthesize(this.beatBuffer, this.beatSpectrum, outBeat, 0, outBeat.length);
    }

    private void process() {
        this.extractEdges();
        this.applyMinSpan();
    }

    private void extractEdges() {
        double sensitivity = AudioMath.dbToLevel(5.0);
        double attack = AudioMath.dbToLevel(15.0);
        float lower = (float)AudioMath.dbToLevel(-100.0) * (float)sensitivity;
        this.engine.push(this.spectrum);
        int i = 0;
        while (i < this.spectrum.length) {
            float startLevel;
            float thresholdNext;
            float thresholdPrev;
            int n = i;
            this.attackLevels[n] = (float)((double)this.attackLevels[n] * attack);
            if (this.attackLevels[i] > 10.0f) {
                this.attackLevels[i] = 10.0f;
            }
            Cmplx source = this.spectrum[i];
            float level = source.magApprox();
            float threshold = this.engine.getMinAvgLevel(i) * (float)sensitivity;
            if (i > 0 && (thresholdPrev = this.engine.getMinAvgLevel(i - 1) * (float)sensitivity) > threshold) {
                threshold = thresholdPrev;
            }
            if (i < this.spectrum.length - 1 && (thresholdNext = this.engine.getMinAvgLevel(i + 1) * (float)sensitivity) > threshold) {
                threshold = thresholdNext;
            }
            if (threshold < lower) {
                threshold = lower;
            }
            if (level > threshold && (startLevel = this.engine.getMinLevel(i)) < this.attackLevels[i]) {
                this.attackLevels[i] = startLevel;
            }
            if (level > this.attackLevels[i]) {
                float cropped = this.attackLevels[i];
                float edgeRatio = (level - cropped) / level;
                float restRatio = 1.0f - edgeRatio;
                this.beatSpectrum[i].set(source.re * edgeRatio, source.im * edgeRatio);
                this.restSpectrum[i].set(source.re * restRatio, source.im * restRatio);
            } else {
                this.beatSpectrum[i].set(0.0f, 0.0f);
                this.restSpectrum[i].set(source);
            }
            ++i;
        }
    }

    private void applyMinSpan() {
        int start = -1;
        int i = 0;
        while (i <= this.beatSpectrum.length) {
            boolean isShort;
            boolean bl = isShort = i < this.beatSpectrum.length && !this.beatSpectrum[i].isZero();
            if (isShort) {
                if (start < 0) {
                    start = i;
                }
            } else if (start >= 0) {
                int span = i - start;
                if (span < 20) {
                    int j = start;
                    while (j < i) {
                        this.restSpectrum[j].add(this.beatSpectrum[j]);
                        this.beatSpectrum[j].clear();
                        ++j;
                    }
                }
                start = -1;
            }
            ++i;
        }
    }
}

