/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio;

import ch.tachyon.sonics.snd2img.dsp.AudioMath;
import ch.tachyon.sonics.snd2img.dsp.AverageBuffer;
import ch.tachyon.sonics.snd2img.dsp.Cmplx;
import ch.tachyon.sonics.snd2img.dsp.MaxBuffer;

public class BeatExtractEngine {
    private static final float THRESHOLD = (float)AudioMath.dbToLevel(-80.0);
    private int nbBins;
    private int length;
    private MaxBuffer[] minAvgBuffers;
    private MaxBuffer[] minBuffers;
    private int[] ages;
    private AverageBuffer[] avgLevels;
    private float[] decayLevels;

    public BeatExtractEngine(int nbBins, int length, int avgLength) {
        this.setSize(nbBins, length, avgLength);
    }

    public void setSize(int nbBins, int length, int avgLength) {
        this.nbBins = nbBins;
        this.length = length;
        this.minAvgBuffers = new MaxBuffer[nbBins];
        this.minBuffers = new MaxBuffer[nbBins];
        this.ages = new int[nbBins];
        this.avgLevels = new AverageBuffer[nbBins];
        this.decayLevels = new float[nbBins];
        int i = 0;
        while (i < this.minAvgBuffers.length) {
            this.minAvgBuffers[i] = new MaxBuffer(length, -THRESHOLD);
            this.minBuffers[i] = new MaxBuffer(length, -THRESHOLD);
            this.avgLevels[i] = new AverageBuffer(avgLength);
            int k = 0;
            while (k < avgLength) {
                this.avgLevels[i].push(THRESHOLD);
                ++k;
            }
            ++i;
        }
    }

    public void push(Cmplx[] spectrum) {
        if (spectrum.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < spectrum.length) {
            float level = spectrum[i].magApprox();
            this.avgLevels[i].push(level);
            this.minBuffers[i].push(-level);
            level = this.avgLevels[i].getAverage();
            this.minAvgBuffers[i].push(-level);
            ++i;
        }
    }

    public float getAvgLevel(int binNum) {
        return this.avgLevels[binNum].getAverage();
    }

    public float getMinAvgLevel(int binNum) {
        float result = -this.minAvgBuffers[binNum].getMax();
        if (result < THRESHOLD) {
            result = THRESHOLD;
        }
        return result;
    }

    public float getMinLevel(int binNum) {
        float result = -this.minBuffers[binNum].getMax();
        if (result < THRESHOLD) {
            result = THRESHOLD;
        }
        return result;
    }

    public int getAge(int binNum) {
        return this.ages[binNum];
    }

    public int incAge(int binNum) {
        int n = binNum;
        int n2 = this.ages[n];
        this.ages[n] = n2 + 1;
        return n2;
    }

    public void resetAge(int binNum) {
        this.ages[binNum] = 0;
    }

    public float decayLevel(int binNum, float level, float decaySpeed) {
        int n = binNum;
        this.decayLevels[n] = this.decayLevels[n] * decaySpeed;
        if (level > this.decayLevels[binNum]) {
            this.decayLevels[binNum] = level;
        }
        return this.decayLevels[binNum];
    }

    public float getAverageLevel(int binNum) {
        return this.avgLevels[binNum].getAverage();
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public int getLength() {
        return this.length;
    }
}

