/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio;

import ch.tachyon.sonics.snd2img.audio.StftEngine;
import ch.tachyon.sonics.snd2img.audio.StftSynthesisBuffer;
import ch.tachyon.sonics.snd2img.dsp.AudioMath;
import ch.tachyon.sonics.snd2img.dsp.Cmplx;
import java.util.Arrays;
import java.util.BitSet;

public class SinesExtract
extends StftEngine {
    public static final int BLOCK_SIZE = 4096;
    public static final int HOP_SIZE = 1024;
    private static final int NB_BANDS = 10;
    private static final int BAND_OVERLAP = 2;
    private static final double RANK = 0.5;
    private static final double SIN_LEVEL = 10.0;
    private static final int MIN_BAND_SPAN = 5;
    private static final double REJECT_LEVEL = -40.0;
    private static final double LOWER_FREQ = 200.0;
    private static final double UPPER_FREQ = 8000.0;
    private final double sampleRate;
    private final StftSynthesisBuffer noiseBuffer;
    private final StftSynthesisBuffer sinesBuffer;
    private final Cmplx[] noiseSpectrum;
    private final Cmplx[] sinesSpectrum;
    private final int[] bounds;
    private final float[] levels;
    private final float[] bandLevels;
    private final BitSet sinusMap;

    public SinesExtract(double sampleRate) {
        super(4096, 1024);
        this.sampleRate = sampleRate;
        this.noiseBuffer = new StftSynthesisBuffer(4096, 1024);
        this.sinesBuffer = new StftSynthesisBuffer(4096, 1024);
        this.noiseSpectrum = Cmplx.newArray(this.nbBins);
        this.sinesSpectrum = Cmplx.newArray(this.nbBins);
        this.levels = new float[this.nbBins];
        this.bandLevels = new float[this.nbBins];
        this.sinusMap = new BitSet(this.nbBins);
        int nbBounds = 11;
        this.bounds = new int[nbBounds];
        int prevBin = 0;
        int i = 0;
        while (i < nbBounds) {
            int bin = (int)(Math.exp(Math.log(this.nbBins) * (double)(i + 1) / (double)nbBounds) + 0.5);
            if (bin < prevBin + 5) {
                bin = prevBin + 5;
            }
            this.bounds[i] = bin;
            prevBin = bin;
            ++i;
        }
    }

    public void process(float[] input, float[] outNoise, float[] outSines) {
        this.analyse(input, 0, input.length);
        this.process(this.spectrum, this.noiseSpectrum, this.sinesSpectrum);
        this.callAnalysers(this.sinesSpectrum);
        this.synthesize(this.noiseBuffer, this.noiseSpectrum, outNoise, 0, outNoise.length);
        this.synthesize(this.sinesBuffer, this.sinesSpectrum, outSines, 0, outSines.length);
    }

    private void process(Cmplx[] input, Cmplx[] outNoise, Cmplx[] outSines) {
        this.sinusMap.clear();
        int lowerIndex = (int)(200.0 * (double)this.blockSize / this.sampleRate + 0.5);
        int upperIndex = (int)(8000.0 * (double)this.blockSize / this.sampleRate + 0.5);
        int i = 0;
        while (i < input.length) {
            this.levels[i] = input[i].powerMag();
            ++i;
        }
        int band = 0;
        while (band < 10) {
            int lower = band == 0 ? 0 : this.bounds[band - 1];
            int upper = this.bounds[band + 2 - 1];
            float maxLevel = 0.0f;
            int i2 = lower;
            while (i2 < upper) {
                if (this.levels[i2] > maxLevel) {
                    maxLevel = this.levels[i2];
                }
                ++i2;
            }
            float rejectLevel = maxLevel * (float)AudioMath.dbToPowerLevel(-40.0);
            int count = 0;
            int i3 = lower;
            while (i3 < upper) {
                if (this.levels[i3] >= rejectLevel) {
                    this.bandLevels[count++] = this.levels[i3];
                }
                ++i3;
            }
            assert (count > 0);
            Arrays.sort(this.bandLevels, 0, count);
            int pivotIndex = (int)(0.5 * (double)(count - 1) + 0.5);
            float pivotLevel = this.bandLevels[pivotIndex];
            pivotLevel = (float)((double)pivotLevel * AudioMath.dbToPowerLevel(10.0));
            int i4 = lower;
            while (i4 < upper) {
                if (i4 < lowerIndex) {
                    this.sinusMap.set(i4);
                } else if (i4 < upperIndex && this.levels[i4] >= pivotLevel) {
                    this.sinusMap.set(i4);
                }
                ++i4;
            }
            ++band;
        }
        i = 0;
        while (i < input.length) {
            if (this.sinusMap.get(i)) {
                outNoise[i].clear();
                outSines[i].set(input[i]);
            } else {
                outNoise[i].set(input[i]);
                outSines[i].clear();
            }
            ++i;
        }
    }
}

