/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio;

import ch.tachyon.sonics.snd2img.audio.SpectrumAnalyser;
import ch.tachyon.sonics.snd2img.audio.StftSynthesisBuffer;
import ch.tachyon.sonics.snd2img.dsp.BooFFT;
import ch.tachyon.sonics.snd2img.dsp.Cmplx;
import ch.tachyon.sonics.snd2img.dsp.Windows;
import java.util.ArrayList;
import java.util.List;

public abstract class StftEngine {
    protected final int blockSize;
    protected final int hopSize;
    protected final int nbBins;
    protected final float[] inBuffer;
    protected int inIndex;
    protected final BooFFT fft;
    protected final Cmplx[] spectrum;
    protected final List<SpectrumAnalyser> analysers = new ArrayList<SpectrumAnalyser>();

    public StftEngine(int blockSize, int hopSize) {
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.nbBins = blockSize / 2 + 1;
        this.inBuffer = new float[blockSize];
        this.fft = BooFFT.getInstance(blockSize / 2);
        this.spectrum = Cmplx.newArray(this.nbBins);
    }

    protected void analyse(float[] input, int offset, int length) {
        if (length != this.hopSize) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize " + this.hopSize);
        }
        System.arraycopy(input, offset, this.inBuffer, this.inIndex, length);
        this.inIndex = (this.inIndex + this.hopSize) % this.blockSize;
        this.fft.forwR2C(this.inBuffer, this.inIndex, this.blockSize, this.blockSize, this.spectrum);
        Windows.convolve2(this.spectrum, Windows.HannCoefs[0], Windows.HannCoefs[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callAnalysers(Cmplx[] spectrum) {
        List<SpectrumAnalyser> list = this.analysers;
        synchronized (list) {
            for (SpectrumAnalyser analyser : this.analysers) {
                analyser.analyse(spectrum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnalyser(SpectrumAnalyser analyser) {
        List<SpectrumAnalyser> list = this.analysers;
        synchronized (list) {
            this.analysers.add(analyser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnalyser(SpectrumAnalyser analyser) {
        List<SpectrumAnalyser> list = this.analysers;
        synchronized (list) {
            this.analysers.remove(analyser);
        }
    }

    protected void synthesize(StftSynthesisBuffer buffer, Cmplx[] spectrum, float[] output, int offset, int length) {
        if (length != this.hopSize) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize " + this.hopSize);
        }
        Windows.convolve2(spectrum, Windows.HannCoefs[0], Windows.HannCoefs[1]);
        this.fft.backC2R(spectrum, buffer.outBlock);
        float correction = StftEngine.getHannCorrection(this.blockSize / this.hopSize, 2);
        int i = 0;
        while (i < this.blockSize - this.hopSize) {
            int n = (i + buffer.outIndex) % this.blockSize;
            buffer.outBuffer[n] = buffer.outBuffer[n] + buffer.outBlock[i];
            ++i;
        }
        i = this.blockSize - this.hopSize;
        while (i < this.blockSize) {
            buffer.outBuffer[(i + buffer.outIndex) % this.blockSize] = buffer.outBlock[i];
            ++i;
        }
        buffer.outIndex = (buffer.outIndex + this.hopSize) % this.blockSize;
        i = 0;
        while (i < length) {
            output[i + offset] = buffer.outBuffer[i + buffer.outIndex] * correction;
            ++i;
        }
    }

    private static float getHannCorrection(int overlapping, int count) {
        if (overlapping <= count) {
            throw new IllegalArgumentException("Constant value only if overpping > count");
        }
        return (float)count / (float)(overlapping - 1);
    }
}

