/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio;

import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.audio.BeatExtract;
import ch.tachyon.sonics.snd2img.audio.SinesExtract;
import ch.tachyon.sonics.snd2img.audio.StftAnalyser;
import ch.tachyon.sonics.snd2img.audio.feature.BeatLevelsAnalyser;
import ch.tachyon.sonics.snd2img.audio.feature.NoiseColorAnalyzer;
import ch.tachyon.sonics.snd2img.audio.feature.NotesAnalyser;

public class StnAnalyser {
    public static final int INPUT_SIZE = 32;
    private static final int NOISE_BLOCK_SIZE = 2048;
    private static final int NOISE_HOP_SIZE = 512;
    private final BeatExtract beatExtract = new BeatExtract();
    private final SinesExtract sinesExtract;
    private final StftAnalyser noiseAnalyser;
    private final BeatLevelsAnalyser beatLevelsAnalyser;
    private final NoiseColorAnalyzer noiseColorAnalyzer;
    private final NotesAnalyser sinesNotesAnalyser;
    private final float[] outBeat;
    private final float[] outNonBeat;
    private final float[] nsBuffer;
    private final float[] outNonSines;
    private final float[] outSines;
    private final float[] noiseBuffer;
    private int noiseIndex;
    private int noiseAmount;
    private int nsIndex;

    public StnAnalyser(double sampleRate, SoundFeaturesBlackboard blackboard) {
        this.sinesExtract = new SinesExtract(sampleRate);
        this.noiseAnalyser = new StftAnalyser(2048, 512);
        this.beatLevelsAnalyser = new BeatLevelsAnalyser(sampleRate, 128, blackboard);
        this.noiseColorAnalyzer = new NoiseColorAnalyzer(sampleRate, 2048, blackboard);
        this.sinesNotesAnalyser = new NotesAnalyser(sampleRate, 4096, blackboard);
        this.outBeat = new float[32];
        this.outNonBeat = new float[32];
        this.nsBuffer = new float[1024];
        this.outNonSines = new float[1024];
        this.outSines = new float[1024];
        this.noiseBuffer = new float[512];
        this.beatExtract.addAnalyser(this.beatLevelsAnalyser);
        this.sinesExtract.addAnalyser(this.sinesNotesAnalyser);
        this.noiseAnalyser.addAnalyser(this.noiseColorAnalyzer);
    }

    public void process(float[] input, float[] output) {
        if (input.length != 32 || output.length != 32) {
            throw new IllegalArgumentException();
        }
        OutputComponent DEBUG_OUTPUT_COMP = OutputComponent.ALL;
        this.beatExtract.process(input, this.outBeat, this.outNonBeat);
        if (DEBUG_OUTPUT_COMP == OutputComponent.ALL) {
            System.arraycopy(input, 0, output, 0, 32);
        }
        if (DEBUG_OUTPUT_COMP == OutputComponent.BEATS) {
            System.arraycopy(this.outBeat, 0, output, 0, 32);
        }
        System.arraycopy(this.outNonBeat, 0, this.nsBuffer, this.nsIndex, 32);
        this.nsIndex += 32;
        if (this.nsIndex >= this.nsBuffer.length) {
            this.sinesExtract.process(this.nsBuffer, this.outNonSines, this.outSines);
            this.nsIndex = 0;
            this.noiseIndex = 0;
        }
        if (DEBUG_OUTPUT_COMP == OutputComponent.SINES) {
            System.arraycopy(this.outSines, this.noiseIndex, output, 0, 32);
        }
        System.arraycopy(this.outNonSines, this.noiseIndex, this.noiseBuffer, this.noiseAmount, 32);
        if (DEBUG_OUTPUT_COMP == OutputComponent.NOISE) {
            System.arraycopy(this.noiseBuffer, this.noiseAmount, output, 0, 32);
        }
        this.noiseIndex += 32;
        this.noiseAmount += 32;
        if (this.noiseAmount >= 512) {
            this.noiseAnalyser.process(this.noiseBuffer);
            this.noiseAmount = 0;
        }
    }

    public static enum OutputComponent {
        ALL,
        SINES,
        BEATS,
        NOISE;

    }
}

