/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio.feature;

import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.audio.feature.FrequencyAnalyser;
import ch.tachyon.sonics.snd2img.dsp.AudioMath;
import ch.tachyon.sonics.snd2img.dsp.Cmplx;
import ch.tachyon.sonics.snd2img.dsp.ParabolicInterpolator;
import java.util.Arrays;

public class BeatLevelsAnalyser
extends FrequencyAnalyser {
    private static final double LOW_FREQ = 1000.0;
    private static final double MID_FREQ_LOWER = 2000.0;
    private static final double MID_FREQ_UPPER = 4000.0;
    private static final double HIGH_FREQ = 9000.0;
    private static final double LOG_LOW_FREQ = Math.log(1000.0);
    private static final double LOG_MID_FREQ_LOWER = Math.log(2000.0);
    private static final double LOG_MID_FREQ_UPPER = Math.log(4000.0);
    private static final double LOG_HIGH_FREQ = Math.log(9000.0);
    private static final int LOW_INDEX = 0;
    private static final int MID_INDEX = 1;
    private static final int HIGH_INDEX = 2;
    private double[] levelArr = new double[3];

    public BeatLevelsAnalyser(double sampleRate, int fftSize, SoundFeaturesBlackboard blackboard) {
        super(sampleRate, fftSize, blackboard);
    }

    @Override
    public void analyse(Cmplx[] spectrum) {
        super.fillLevels(spectrum);
        Arrays.fill(this.levelArr, 0.0);
        int i = 0;
        while (i < this.levels.length) {
            if (this.isPeak(i)) {
                this.processFrequency(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.levelArr.length) {
            this.blackboard.writeBeatLevel(i, this.levelArr[i]);
            ++i;
        }
    }

    private void processFrequency(int index) {
        double fw1;
        int cpIndex1;
        int cpIndex0;
        double freq;
        double next;
        double cur;
        double prev = AudioMath.powerLevelToDb0(this.getLevel(index - 1));
        double center = (double)index + ParabolicInterpolator.interpolateX(prev, cur = AudioMath.powerLevelToDb0(this.getLevel(index)), next = AudioMath.powerLevelToDb0(this.getLevel(index + 1)));
        if (Double.isInfinite(center) || Double.isNaN(center)) {
            center = index;
        }
        if ((freq = center * this.sampleRate / (double)this.fftSize) < 1000.0) {
            cpIndex0 = 0;
            cpIndex1 = 0;
            fw1 = 1.0;
        } else if (freq < 2000.0) {
            cpIndex0 = 0;
            cpIndex1 = 1;
            fw1 = this.logWeight1(LOG_LOW_FREQ, LOG_MID_FREQ_LOWER, freq);
        } else if (freq < 4000.0) {
            cpIndex0 = 1;
            cpIndex1 = 1;
            fw1 = 1.0;
        } else if (freq < 9000.0) {
            cpIndex0 = 1;
            cpIndex1 = 2;
            fw1 = this.logWeight1(LOG_MID_FREQ_UPPER, LOG_HIGH_FREQ, freq);
        } else {
            cpIndex0 = 2;
            cpIndex1 = 2;
            fw1 = 1.0;
        }
        double fw0 = 1.0 - fw1;
        fw0 = Math.sqrt(fw0 * fw0);
        fw1 = Math.sqrt(fw1 * fw1);
        double level = this.getMagnitude(index);
        int n = cpIndex0;
        this.levelArr[n] = this.levelArr[n] + level * fw0;
        int n2 = cpIndex1;
        this.levelArr[n2] = this.levelArr[n2] + level * fw1;
    }
}

