/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio.feature;

import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.audio.SpectrumAnalyser;
import ch.tachyon.sonics.snd2img.dsp.Cmplx;

public abstract class FrequencyAnalyser
extends SpectrumAnalyser {
    protected static final double BOOST_LOW = 1.5;
    protected static final double BOOST_MID = 2.0;
    protected static final double BOOST_HIGH = 1.0;
    protected static final double LOW_FREQ = 150.0;
    protected static final double MID_FREQ_LOWER = 400.0;
    protected static final double MID_FREQ_UPPER = 900.0;
    protected static final double HIGH_FREQ = 2000.0;
    protected static final double LOG_LOW_FREQ = Math.log(150.0);
    protected static final double LOG_MID_FREQ_LOWER = Math.log(400.0);
    protected static final double LOG_MID_FREQ_UPPER = Math.log(900.0);
    protected static final double LOG_HIGH_FREQ = Math.log(2000.0);
    protected final double sampleRate;
    protected final int fftSize;
    protected final SoundFeaturesBlackboard blackboard;
    protected float[] levels;

    public FrequencyAnalyser(double sampleRate, int fftSize, SoundFeaturesBlackboard blackboard) {
        this.sampleRate = sampleRate;
        this.fftSize = fftSize;
        this.blackboard = blackboard;
    }

    protected void fillLevels(Cmplx[] spectrum) {
        if (this.levels == null) {
            this.levels = new float[spectrum.length];
        }
        int i = 0;
        while (i < spectrum.length) {
            this.levels[i] = spectrum[i].magApprox();
            ++i;
        }
    }

    protected boolean isPeak(int index) {
        float prev2 = this.getLevel(index - 2);
        float prev = this.getLevel(index - 1);
        float cur = this.getLevel(index);
        float next = this.getLevel(index + 1);
        float next2 = this.getLevel(index + 2);
        return cur > prev && cur >= next && cur > prev2 && cur >= next2;
    }

    protected float getLevel(int index) {
        if (index < 0 || index >= this.levels.length) {
            return 0.0f;
        }
        return this.levels[index];
    }

    protected double getMagnitude(int index) {
        float prev = this.getLevel(index - 1);
        float cur = this.getLevel(index);
        float next = this.getLevel(index + 1);
        return Math.sqrt(prev + cur + next);
    }

    protected double logWeight1(double logLower, double logUpper, double value) {
        double logValue = Math.log(value);
        assert ((float)logValue >= (float)logLower && (float)logValue <= (float)logUpper);
        return (logValue - logLower) / (logUpper - logLower);
    }
}

