/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio.feature;

import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.audio.SpectrumAnalyser;
import ch.tachyon.sonics.snd2img.dsp.Cmplx;

public class NoiseColorAnalyzer
extends SpectrumAnalyser {
    private static final double MIN_FREQ = 800.0;
    private static final double MAX_FREQ = 8000.0;
    private static final double LOG_MIN_FREQ = Math.log(800.0);
    private static final double LOG_MAX_FREQ = Math.log(8000.0);
    private final double sampleRate;
    private final int fftSize;
    private final SoundFeaturesBlackboard blackboard;
    private double[] reds;
    private double[] greens;
    private double[] blues;

    public NoiseColorAnalyzer(double sampleRate, int fftSize, SoundFeaturesBlackboard blackboard) {
        this.sampleRate = sampleRate;
        this.fftSize = fftSize;
        this.blackboard = blackboard;
    }

    @Override
    public void analyse(Cmplx[] spectrum) {
        if (this.reds == null || this.reds.length != spectrum.length) {
            this.buildLookupTable(spectrum);
        }
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        int i = 0;
        while (i < spectrum.length) {
            double level = spectrum[i].magApprox();
            red += this.reds[i] * level;
            green += this.greens[i] * level;
            blue += this.blues[i] * level;
            ++i;
        }
        this.blackboard.writeNoiseRed(red);
        this.blackboard.writeNoiseGreen(green);
        this.blackboard.writeNoiseBlue(blue);
    }

    private void buildLookupTable(Cmplx[] spectrum) {
        int nbBins = spectrum.length;
        this.reds = new double[nbBins];
        this.greens = new double[nbBins];
        this.blues = new double[nbBins];
        int i = 0;
        while (i < nbBins) {
            double freq = (double)i * this.sampleRate / (double)this.fftSize;
            double logFreq = Math.log(freq);
            if (logFreq < LOG_MIN_FREQ) {
                this.reds[i] = 1.0;
            } else if (logFreq > LOG_MAX_FREQ) {
                this.blues[i] = 1.0;
            } else {
                double logMidFreq = (LOG_MIN_FREQ + LOG_MAX_FREQ) / 2.0;
                if (logFreq < logMidFreq) {
                    double wg = (logFreq - LOG_MIN_FREQ) / (logMidFreq - LOG_MIN_FREQ);
                    double wr = 1.0 - wg;
                    this.greens[i] = Math.sqrt(wg);
                    this.reds[i] = Math.sqrt(wr);
                } else {
                    double wb = (logFreq - logMidFreq) / (LOG_MAX_FREQ - logMidFreq);
                    double wg = 1.0 - wb;
                    this.greens[i] = Math.sqrt(wg);
                    this.blues[i] = Math.sqrt(wb);
                }
            }
            ++i;
        }
    }
}

