/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.audio.feature;

import ch.tachyon.sonics.snd2img.SoundFeaturesBlackboard;
import ch.tachyon.sonics.snd2img.audio.feature.FrequencyAnalyser;
import ch.tachyon.sonics.snd2img.dsp.AudioMath;
import ch.tachyon.sonics.snd2img.dsp.Cmplx;
import ch.tachyon.sonics.snd2img.dsp.ParabolicInterpolator;
import java.util.Arrays;

public class NotesAnalyser
extends FrequencyAnalyser {
    private static final double BOOST = 0.375;
    private static final double RANGE = 4.0;
    private static final double RANGE_DIVISIONS = 24.0;
    private static final double DIV_TONE = Math.pow(4.0, 0.041666666666666664);
    private static final double DIV_TONE_LOG = Math.log(DIV_TONE);
    private static final double BASE_TONE = 440.0;
    private static final double MIN_TONE = 20.0;
    private static final double MAX_TONE = 8000.0;
    private static final double BASE_TONE_INDEX = Math.log(440.0) / DIV_TONE_LOG;
    private static final double MIN_TONE_INDEX = Math.log(20.0) / DIV_TONE_LOG - BASE_TONE_INDEX;
    private static final double MAX_TONE_INDEX = Math.log(8000.0) / DIV_TONE_LOG - BASE_TONE_INDEX;
    private final double[] notes = new double[24];
    private final double[] notesLow = new double[24];
    private final double[] notesMid = new double[24];
    private final double[] notesHigh = new double[24];

    public NotesAnalyser(double sampleRate, int fftSize, SoundFeaturesBlackboard blackboard) {
        super(sampleRate, fftSize, blackboard);
    }

    @Override
    public void analyse(Cmplx[] spectrum) {
        if (this.levels == null) {
            this.levels = new float[spectrum.length];
        }
        int i = 0;
        while (i < spectrum.length) {
            this.levels[i] = spectrum[i].magApprox();
            ++i;
        }
        Arrays.fill(this.notes, 0.0);
        Arrays.fill(this.notesLow, 0.0);
        Arrays.fill(this.notesMid, 0.0);
        Arrays.fill(this.notesHigh, 0.0);
        i = 0;
        while (i < this.levels.length) {
            if (this.isPeak(i)) {
                this.processFrequency(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.notes.length) {
            this.blackboard.writeSinesNote(i, this.notes[i]);
            this.blackboard.writeSinesNoteLow(i, this.notesLow[i] * 1.5);
            this.blackboard.writeSinesNoteMid(i, this.notesMid[i] * 2.0);
            this.blackboard.writeSinesNoteHigh(i, this.notesHigh[i] * 1.0);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processFrequency(int index) {
        prev = AudioMath.powerLevelToDb0(this.getLevel(index - 1));
        center = (double)index + ParabolicInterpolator.interpolateX(prev, cur = AudioMath.powerLevelToDb0(this.getLevel(index)), next = AudioMath.powerLevelToDb0(this.getLevel(index + 1)));
        if (Double.isInfinite(center) || Double.isNaN(center)) {
            center = index;
        }
        if (Double.isInfinite(toneIndex = Math.log(freq = center * this.sampleRate / (double)this.fftSize) / NotesAnalyser.DIV_TONE_LOG - NotesAnalyser.BASE_TONE_INDEX) || Double.isNaN(toneIndex)) {
            return;
        }
        if (!(toneIndex < NotesAnalyser.MIN_TONE_INDEX) && !(toneIndex > NotesAnalyser.MAX_TONE_INDEX)) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            toneIndex += (double)this.notes.length;
lbl10:
            // 2 sources

            ** while (toneIndex < 0.0)
        }
lbl11:
        // 2 sources

        while (toneIndex >= (double)this.notes.length) {
            toneIndex -= (double)this.notes.length;
        }
        toneIndex0 = (int)toneIndex;
        toneIndex1 = (toneIndex0 + 1) % this.notes.length;
        w1 = toneIndex - (double)toneIndex0;
        w0 = 1.0 - w1;
        w0 = Math.sqrt(w0 * w0);
        w1 = Math.sqrt(w1 * w1);
        level = this.getMagnitude(index);
        v0 = toneIndex0;
        this.notes[v0] = this.notes[v0] + level * w0 * 0.375;
        v1 = toneIndex1;
        this.notes[v1] = this.notes[v1] + level * w1 * 0.375;
        if (freq < 150.0) {
            fnotes0 = this.notesLow;
            fnotes1 = this.notesLow;
            fw1 = 1.0;
        } else if (freq < 400.0) {
            fnotes0 = this.notesLow;
            fnotes1 = this.notesMid;
            fw1 = this.logWeight1(NotesAnalyser.LOG_LOW_FREQ, NotesAnalyser.LOG_MID_FREQ_LOWER, freq);
        } else if (freq < 900.0) {
            fnotes0 = this.notesMid;
            fnotes1 = this.notesMid;
            fw1 = 1.0;
        } else if (freq < 2000.0) {
            fnotes0 = this.notesMid;
            fnotes1 = this.notesHigh;
            fw1 = this.logWeight1(NotesAnalyser.LOG_MID_FREQ_UPPER, NotesAnalyser.LOG_HIGH_FREQ, freq);
        } else {
            fnotes0 = this.notesHigh;
            fnotes1 = this.notesHigh;
            fw1 = 1.0;
        }
        fw0 = 1.0 - fw1;
        fw0 = Math.sqrt(fw0 * fw0);
        fw1 = Math.sqrt(fw1 * fw1);
        v2 = toneIndex0;
        fnotes0[v2] = fnotes0[v2] + level * w0 * fw0;
        v3 = toneIndex1;
        fnotes0[v3] = fnotes0[v3] + level * w1 * fw0;
        v4 = toneIndex0;
        fnotes1[v4] = fnotes1[v4] + level * w0 * fw1;
        v5 = toneIndex1;
        fnotes1[v5] = fnotes1[v5] + level * w1 * fw1;
    }
}

