/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.dsp;

public class Buffer {
    private int size;
    private float[] values;
    private int index;

    public Buffer(int size) {
        this.size = size;
        this.values = new float[size];
        this.index = 0;
    }

    public double push(double value) {
        return this.push((float)value);
    }

    public float push(float value) {
        if (this.size == 0) {
            return value;
        }
        float old = this.values[this.index];
        this.values[this.index] = value;
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        return old;
    }

    public float peek() {
        return this.values[this.index];
    }

    public void pushArray(float[] values) {
        int i = 0;
        while (i < values.length) {
            values[i] = this.push(values[i]);
            ++i;
        }
    }

    public void pushArray(float[] input, float[] output) {
        int i = 0;
        while (i < input.length) {
            output[i] = this.push(input[i]);
            ++i;
        }
    }

    public void pushArray(float[] input, float[] output, int offset, int length) {
        int i = offset;
        while (i < offset + length) {
            output[i] = this.push(input[i]);
            ++i;
        }
    }

    public void pushArray(float[] input, int inputOffset, float[] output) {
        int i = 0;
        while (i < output.length) {
            output[i] = this.push(input[i + inputOffset]);
            ++i;
        }
    }

    public void pushArray(float[] input, float[] output, int inputOffset, int outputOffset, int length) {
        int i = 0;
        while (i < length) {
            output[i + outputOffset] = this.push(input[i + inputOffset]);
            ++i;
        }
    }

    public void pushArrayAdd(float[] input, float[] output, int inputOffset, int outputOffset, int length) {
        int i = 0;
        while (i < length) {
            int n = i + outputOffset;
            output[n] = output[n] + this.push(input[i + inputOffset]);
            ++i;
        }
    }

    public float getPast(int time) {
        if (time <= 0) {
            throw new IllegalArgumentException("Time must be positive");
        }
        if (time > this.size) {
            throw new IllegalArgumentException("Time is greater than my size");
        }
        int index = (this.index + this.size - time) % this.size;
        return this.values[index];
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size == this.size) {
            return;
        }
        float[] old = this.values;
        this.size = size;
        this.values = new float[size];
        int min = size < old.length ? size : old.length;
        int offset = size - min;
        int i = 0;
        while (i < min) {
            this.values[i + offset] = old[(this.index + i) % old.length];
            ++i;
        }
        this.index = 0;
    }
}

