/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.dsp;

import ch.tachyon.sonics.snd2img.dsp.FastSinCos;
import java.io.Serializable;

public final class Cmplx
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2377021765855242381L;
    public float re;
    public float im;
    public static final Cmplx I = new Cmplx(0.0f, 1.0f);
    private static final Cmplx minusI = new Cmplx(0.0f, -1.0f);

    private Cmplx() {
    }

    private Cmplx(float re, float im) {
        this.re = re;
        this.im = im;
    }

    private Cmplx(Cmplx other) {
        this.re = other.re;
        this.im = other.im;
    }

    public static Cmplx newCmplx() {
        return new Cmplx();
    }

    public static Cmplx newCmplx(float re, float im) {
        return new Cmplx(re, im);
    }

    public Cmplx clone() {
        try {
            return (Cmplx)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof Cmplx)) {
            return false;
        }
        Cmplx other = (Cmplx)o;
        return this.re == other.re && this.im == other.im;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.re) ^ Float.floatToIntBits(this.im);
    }

    public String toString() {
        return "(" + this.re + "," + this.im + ")";
    }

    public void set(float re, float im) {
        this.re = re;
        this.im = im;
    }

    public void clear() {
        this.set(0.0f, 0.0f);
    }

    public boolean isZero() {
        return this.re == 0.0f && this.im == 0.0f;
    }

    public void set(Cmplx value) {
        this.re = value.re;
        this.im = value.im;
    }

    public void copyFrom(Cmplx other) {
        this.re = other.re;
        this.im = other.im;
    }

    public void swapReIm() {
        float tmp = this.re;
        this.re = this.im;
        this.im = tmp;
    }

    public void swapWith(Cmplx other) {
        float tmp = this.re;
        this.re = other.re;
        other.re = tmp;
        tmp = this.im;
        this.im = other.im;
        other.im = tmp;
    }

    public static Cmplx[] newArray(int size) {
        Cmplx[] result = new Cmplx[size];
        int i = 0;
        while (i < size) {
            result[i] = new Cmplx();
            ++i;
        }
        return result;
    }

    public static Cmplx[][] newArray(int size1, int size2) {
        Cmplx[][] result = new Cmplx[size1][size2];
        int i = 0;
        while (i < size1) {
            int j = 0;
            while (j < size2) {
                result[i][j] = new Cmplx();
                ++j;
            }
            ++i;
        }
        return result;
    }

    public void add(Cmplx val) {
        this.re += val.re;
        this.im += val.im;
    }

    public void sum(Cmplx val1, Cmplx val2) {
        this.re = val1.re + val2.re;
        this.im = val1.im + val2.im;
    }

    public void sub(Cmplx val) {
        this.re -= val.re;
        this.im -= val.im;
    }

    public void dif(Cmplx val1, Cmplx val2) {
        this.re = val1.re - val2.re;
        this.im = val1.im - val2.im;
    }

    public void mul(Cmplx val) {
        float re = this.re * val.re - this.im * val.im;
        float im = this.re * val.im + this.im * val.re;
        this.re = re;
        this.im = im;
    }

    public void mul(float val) {
        this.re *= val;
        this.im *= val;
    }

    public void prod(Cmplx val1, Cmplx val2) {
        this.re = val1.re * val2.re - val1.im * val2.im;
        this.im = val1.re * val2.im + val1.im * val2.re;
    }

    public void inv() {
        float den = this.re * this.re + this.im * this.im;
        this.re /= den;
        this.im = -this.im / den;
    }

    public void div(Cmplx val) {
        float den = val.re * val.re + val.im * val.im;
        float re = this.re * val.re + this.im * val.im;
        float im = this.im * val.re - this.re * val.im;
        this.re = re / den;
        this.im = im / den;
    }

    public void quo(Cmplx val1, Cmplx val2) {
        float den = val2.re * val2.re + val2.im * val2.im;
        float re = val1.re * val2.re + val1.im * val2.im;
        float im = val1.im * val2.re - val1.re * val2.im;
        this.re = re / den;
        this.im = im / den;
    }

    public Cmplx toPolar() {
        double mag = Math.hypot(this.re, this.im);
        double phi = Math.atan2(this.im, this.re);
        this.re = (float)mag;
        this.im = (float)phi;
        return this;
    }

    public float mag() {
        return (float)Math.hypot(this.re, this.im);
    }

    public float magApprox() {
        double absIm;
        double ALPHA = 0.948059448969;
        double BETA = 0.392699081699;
        double absRe = this.re < 0.0f ? -this.re : this.re;
        if (absRe > (absIm = (double)(this.im < 0.0f ? -this.im : this.im))) {
            return (float)(0.948059448969 * absRe + 0.392699081699 * absIm);
        }
        return (float)(0.948059448969 * absIm + 0.392699081699 * absRe);
    }

    public float powerMag() {
        return this.re * this.re + this.im * this.im;
    }

    public float phi() {
        return (float)Math.atan2(this.im, this.re);
    }

    public Cmplx toCartesian() {
        double re = (double)this.re * Math.cos(this.im);
        double im = (double)this.re * Math.sin(this.im);
        this.re = (float)re;
        this.im = (float)im;
        return this;
    }

    public Cmplx toCartesianApprox() {
        double re = (double)this.re * FastSinCos.fastCos(this.im);
        double im = (double)this.re * FastSinCos.fastSin(this.im);
        this.re = (float)re;
        this.im = (float)im;
        return this;
    }

    public Cmplx exp() {
        double phi = this.im;
        double mag = Math.exp(this.re);
        this.re = (float)(mag * Math.cos(phi));
        this.im = (float)(mag * Math.sin(phi));
        return this;
    }

    public Cmplx log() {
        double mag = Math.hypot(this.re, this.im);
        double phi = Math.atan2(this.im, this.re);
        this.re = (float)Math.log(mag);
        this.im = (float)phi;
        return this;
    }

    public Cmplx sqrt() {
        double sqrtmag = Math.sqrt(Math.hypot(this.re, this.im));
        double sqrtphi = Math.atan2(this.im, this.re) / 2.0;
        this.re = (float)(sqrtmag * Math.cos(sqrtphi));
        this.im = (float)(sqrtmag * Math.sin(sqrtphi));
        return this;
    }

    public Cmplx pow(Cmplx exp) {
        this.log();
        this.mul(exp);
        this.exp();
        return this;
    }

    public static double acosh(double arg) {
        return Math.log(arg + Math.sqrt(arg * arg - 1.0));
    }

    public static double asinh(double arg) {
        return Math.log(arg + Math.hypot(arg, 1.0));
    }

    public Cmplx cos() {
        double re = Math.cos(this.re) * Math.cosh(this.im);
        double im = Math.sin(this.re) * Math.sinh(this.im);
        this.re = (float)re;
        this.im = -((float)im);
        return this;
    }

    public Cmplx sin() {
        double re = Math.sin(this.re) * Math.cosh(this.im);
        double im = Math.cos(this.re) * Math.sinh(this.im);
        this.re = (float)re;
        this.im = (float)im;
        return this;
    }

    public Cmplx tan() {
        this.mul(I);
        this.tanh();
        this.mul(minusI);
        return this;
    }

    public Cmplx acos() {
        this.acosh();
        this.mul(I);
        return this;
    }

    public Cmplx asin() {
        Cmplx t = new Cmplx(this);
        this.mul(t);
        this.mul(-1.0f);
        this.re += 1.0f;
        this.sqrt();
        t.mul(I);
        this.add(t);
        this.log();
        this.mul(minusI);
        return this;
    }

    public Cmplx atan() {
        Cmplx t = new Cmplx(this);
        t.add(I);
        this.mul(-1.0f);
        this.add(I);
        this.inv();
        this.mul(t);
        this.log();
        this.mul(I);
        this.mul(0.5f);
        return this;
    }

    public Cmplx cosh() {
        double re = Math.cosh(this.re) * Math.cos(this.im);
        double im = Math.sinh(this.re) * Math.sin(this.im);
        this.re = (float)re;
        this.im = (float)im;
        return this;
    }

    public Cmplx sinh() {
        double re = Math.sinh(this.re) * Math.cos(this.im);
        double im = Math.cosh(this.re) * Math.sin(this.im);
        this.re = (float)re;
        this.im = (float)im;
        return this;
    }

    public Cmplx tanh() {
        Cmplx tmp = new Cmplx(this);
        tmp.cosh();
        tmp.inv();
        this.sinh();
        this.mul(tmp);
        return this;
    }

    public Cmplx acosh() {
        Cmplx copy = new Cmplx(this);
        this.mul(copy);
        this.mul(-1.0f);
        this.re += 1.0f;
        this.sqrt();
        this.mul(I);
        this.add(copy);
        this.log();
        this.mul(-1.0f);
        return this;
    }

    public Cmplx asinh() {
        Cmplx copy = new Cmplx(this);
        this.mul(copy);
        this.re += 1.0f;
        this.sqrt();
        this.sub(copy);
        this.log();
        this.mul(-1.0f);
        return this;
    }

    public Cmplx atanh() {
        Cmplx copy = new Cmplx(this);
        copy.re += 1.0f;
        this.mul(-1.0f);
        this.re += 1.0f;
        this.inv();
        this.mul(copy);
        this.log();
        this.mul(0.5f);
        return this;
    }
}

