/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.dsp;

public class FastSinCos {
    private static final double B = 1.2732395447351628;
    private static final double C = -0.4052847345693511;
    private static final double P = 0.218;
    private static final double hPI = 1.5707963267948966;
    private static final double PI2 = Math.PI * 2;
    private static final double sPI = 4.71238898038469;

    public static double wrap(double angle) {
        if ((angle %= Math.PI * 2) > Math.PI) {
            angle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        assert (angle >= -Math.PI && angle <= Math.PI);
        return angle;
    }

    public static double fastSin(double theta) {
        return FastSinCos.fastSin0(FastSinCos.wrap(theta));
    }

    public static double fastCos(double theta) {
        return FastSinCos.fastSin0(FastSinCos.wrap(theta + 1.5707963267948966));
    }

    public static double fastSin0(double theta) {
        double y = 1.2732395447351628 * theta + -0.4052847345693511 * theta * Math.abs(theta);
        y = 0.218 * (y * Math.abs(y) - y) + y;
        return y;
    }

    public static double fastCos0(double theta) {
        theta = theta > 1.5707963267948966 ? (theta -= 4.71238898038469) : (theta += 1.5707963267948966);
        return FastSinCos.fastSin0(theta);
    }
}

