/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.dsp;

public class ParabolicInterpolator {
    private final double x1;
    private final double x2;
    private final double x3;
    private final double y1;
    private final double y2;
    private final double y3;
    private double x = Double.NaN;
    private double y = Double.NaN;

    public ParabolicInterpolator(double x1, double x2, double x3, double y1, double y2, double y3) {
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
        this.y1 = y1;
        this.y2 = y2;
        this.y3 = y3;
    }

    public double getX() {
        if (Double.isNaN(this.x)) {
            this.x = ParabolicInterpolator.interpolateX(this.x1, this.x2, this.x3, this.y1, this.y2, this.y3);
        }
        return this.x;
    }

    public static double interpolateX(double x1, double x2, double x3, double y1, double y2, double y3) {
        double x2mx1 = x2 - x1;
        double x2mx3 = x2 - x3;
        double y2my1 = y2 - y1;
        double y2my3 = y2 - y3;
        return x2 - 0.5 * (x2mx1 * x2mx1 * y2my3 - x2mx3 * x2mx3 * y2my1) / (x2mx1 * y2my3 - x2mx3 * y2my1);
    }

    public static double interpolateX(double y1, double y2, double y3) {
        double result = 0.5 * (y1 - y3) / (y1 - 2.0 * y2 + y3);
        return result;
    }

    public double getY() {
        if (Double.isNaN(this.y)) {
            this.getX();
            double xmx1 = this.x - this.x1;
            double xmx2 = this.x - this.x2;
            double xmx3 = this.x - this.x3;
            this.y = this.y1 * xmx2 * xmx3 / ((this.x1 - this.x2) * (this.x1 - this.x3)) + this.y2 * xmx3 * xmx1 / ((this.x2 - this.x3) * (this.x2 - this.x1)) + this.y3 * xmx1 * xmx2 / ((this.x3 - this.x1) * (this.x3 - this.x2));
        }
        return this.y;
    }

    public static void main(String[] args) {
        double x1 = 10.0;
        double x2 = 15.0;
        double x3 = 20.0;
        double y1 = 8.0;
        double y2 = 10.0;
        double y3 = 13.0;
        ParabolicInterpolator interpolator = new ParabolicInterpolator(x1, x2, x3, y1, y2, y3);
        System.out.println("(" + interpolator.getX() + ", " + interpolator.getY() + ")");
    }
}

