/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.gui;

import java.awt.Component;
import java.awt.FontMetrics;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class FileNameLabelCutter {
    public static String cutFileName(String text, JLabel label, int gap, JComponent ... siblings) {
        String result = text;
        int cutPos = text.lastIndexOf(File.separator);
        if (cutPos > text.length()) {
            cutPos = 1;
        } else if (cutPos <= 0) {
            cutPos = text.length() - 1;
        }
        FontMetrics fm = label.getFontMetrics(label.getFont());
        int maxWidth = label.getParent().getSize().width - label.getInsets().left - label.getInsets().right - gap;
        JComponent[] jComponentArray = siblings;
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent sibling = jComponentArray[n2];
            maxWidth -= ((Component)sibling).getWidth();
            ++n2;
        }
        int width = fm.stringWidth(result);
        if (width <= maxWidth) {
            return result;
        }
        int ellipsisWidth = fm.stringWidth("\u2026");
        while (width + ellipsisWidth > maxWidth) {
            if (cutPos >= result.length()) {
                return result;
            }
            result = String.valueOf(result.substring(0, cutPos - 1)) + result.substring(cutPos);
            width = fm.stringWidth(result);
            if (cutPos <= 1) continue;
            --cutPos;
        }
        if (cutPos == 1) {
            cutPos = 0;
        }
        result = String.valueOf(result.substring(0, cutPos)) + "\u2026" + result.substring(cutPos);
        return result;
    }

    public static String cutFileName(String text, int maxLength) {
        if (text.length() <= maxLength) {
            return text;
        }
        String result = text;
        int minPos = text.length() - maxLength + 1;
        int cutPos = text.substring(minPos).contains(File.separator) ? text.lastIndexOf(File.separator) : (text.substring(minPos).contains(" ") ? text.lastIndexOf(32) : Math.max(Math.max(text.lastIndexOf("."), text.lastIndexOf(95)), text.lastIndexOf(45)));
        if (cutPos > text.length()) {
            cutPos = 1;
        } else if (cutPos <= 0) {
            cutPos = text.length() - 1;
        }
        while (result.length() > maxLength) {
            if (cutPos >= result.length()) {
                return result;
            }
            result = String.valueOf(result.substring(0, cutPos - 1)) + result.substring(cutPos);
            if (cutPos <= 1) continue;
            --cutPos;
        }
        if (cutPos == 1) {
            cutPos = 0;
        }
        result = String.valueOf(result.substring(0, cutPos)) + "\u2026" + result.substring(cutPos);
        return result;
    }
}

