/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.gui;

import ch.tachyon.sonics.snd2img.utils.EtrEstimator;
import ch.tachyon.tunnel.audio.utils.IProgressMonitor;
import ch.tachyon.tunnel.audio.utils.OperationAbortedException;
import java.awt.Taskbar;
import java.awt.Window;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressManager
implements IProgressMonitor {
    private final JProgressBar progressBar;
    private final AtomicBoolean updating = new AtomicBoolean();
    private final AtomicBoolean interrupt = new AtomicBoolean();
    private EtrEstimator etrEstimator;
    private Taskbar taskBar;

    public ProgressManager(JProgressBar progressBar) {
        this.progressBar = progressBar;
        progressBar.setIndeterminate(true);
        progressBar.setString("Scanning input audio file...");
        progressBar.setValue(progressBar.getMinimum());
        if (Taskbar.isTaskbarSupported()) {
            this.taskBar = Taskbar.getTaskbar();
            Window window = SwingUtilities.getWindowAncestor(progressBar);
            this.taskBar.setWindowProgressValue(window, 0);
            this.taskBar.setWindowProgressState(window, Taskbar.State.INDETERMINATE);
        }
    }

    public void interrupt() {
        this.interrupt.set(true);
    }

    @Override
    public void setProgress(double current, double total) throws OperationAbortedException {
        if (this.interrupt.get()) {
            throw new OperationAbortedException(true);
        }
        if (current < total && this.updating.get()) {
            return;
        }
        this.updating.set(true);
        SwingUtilities.invokeLater(() -> {
            if (this.etrEstimator == null) {
                this.etrEstimator = new EtrEstimator();
            }
            int minimum = this.progressBar.getMinimum();
            int maximum = this.progressBar.getMaximum();
            int range = maximum - minimum;
            int value = minimum + (int)((double)range * current / total + 0.01);
            boolean start = false;
            if (this.progressBar.isIndeterminate()) {
                this.progressBar.setIndeterminate(false);
                this.progressBar.setToolTipText("Conversion in progress...");
                start = true;
            }
            this.progressBar.setValue(value);
            this.progressBar.setString(this.etrEstimator.getEtr("Converting", current * 100.0 / total));
            this.progressBar.repaint();
            if (this.taskBar != null) {
                Window window = SwingUtilities.getWindowAncestor(this.progressBar);
                if (start) {
                    this.taskBar.setWindowProgressState(window, Taskbar.State.NORMAL);
                }
                int percent = (int)(current * 100.0 / total + 0.01);
                this.taskBar.setWindowProgressValue(window, percent);
            }
            this.updating.set(false);
        });
    }

    public void close() {
        if (this.taskBar != null) {
            Window window = SwingUtilities.getWindowAncestor(this.progressBar);
            this.taskBar.setWindowProgressState(window, Taskbar.State.OFF);
        }
    }
}

