/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.gui;

import ch.tachyon.sonics.snd2img.SoundToImageConverter;
import ch.tachyon.sonics.snd2img.VideoResolutionType;
import ch.tachyon.sonics.snd2img.gui.FileNameLabelCutter;
import ch.tachyon.sonics.snd2img.gui.FileTransferHandler;
import ch.tachyon.sonics.snd2img.gui.ProgressManager;
import ch.tachyon.sonics.snd2img.gui.VideoFileFilter;
import ch.tachyon.sonics.snd2img.gui.icon.Icons;
import ch.tachyon.sonics.snd2img.gui.icon.JMultiImageIcon;
import ch.tachyon.tunnel.audio.file.AudioFileFilter;
import ch.tachyon.tunnel.audio.utils.OperationAbortedException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.StringUtils;

public class SoundToImageFrame
extends JFrame {
    private File inputAudioFile;
    private File outputVideoFile;
    private JProgressBar progressBar;
    private JFileChooser inputChooser;
    private JFileChooser outputChooser;
    private JLabel lblInput;
    private JLabel txtInput;
    private JButton btnInput;
    private JLabel lblOutput;
    private JLabel txtOutput;
    private JComboBox<VideoResolutionType> cbResolution;
    private JButton btnOutput;
    private JButton btnOk;
    private JButton btnCancel;
    private JCheckBox chkShow;
    private volatile boolean showOutputFileOnCompletion = true;
    private volatile boolean quit;
    private volatile ProgressManager progress;

    public SoundToImageFrame() throws HeadlessException {
        this.setTitle("snd2img 0.9.3");
        this.setIconImages(Icons.getFrameImages());
        this.getContentPane().setLayout(new BorderLayout());
        JPanel titlePanel = new JPanel(new FlowLayout());
        titlePanel.setName("Title");
        this.getContentPane().add((Component)titlePanel, "North");
        JMultiImageIcon icon = new JMultiImageIcon(Icons.getLogoImages(), 64, 64);
        titlePanel.add(icon);
        JLabel txtTitle = new JLabel("snd2img");
        txtTitle.setFont(txtTitle.getFont().deriveFont(32.0f));
        titlePanel.add(txtTitle);
        String tooltip = "Create a video from an audio file";
        icon.setToolTipText(tooltip);
        txtTitle.setToolTipText(tooltip);
        JPanel paramsPanel0 = new JPanel(new BorderLayout());
        paramsPanel0.setBorder(new EmptyBorder(0, 10, 10, 10));
        this.getContentPane().add((Component)paramsPanel0, "Center");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(1, 2, 0, 2);
        GridBagConstraints gbcT = (GridBagConstraints)gbc.clone();
        gbcT.weightx = 1.0;
        JPanel paramsPanel = new JPanel(new TableLayout(3, gbc));
        paramsPanel0.add((Component)paramsPanel, "Center");
        this.lblInput = new JLabel("Input Audio File: ");
        paramsPanel.add(this.lblInput);
        this.txtInput = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.txtInput.setToolTipText("Drop an audio file here");
        this.txtInput.setBorder(new EtchedBorder());
        this.installDragAndDrop(this.txtInput);
        paramsPanel.add((Component)this.txtInput, gbcT);
        this.btnInput = new JButton("Choose...");
        this.lblInput.setDisplayedMnemonic('i');
        this.lblInput.setLabelFor(this.btnInput);
        this.btnInput.addActionListener(this::chooseInputFile);
        paramsPanel.add(this.btnInput);
        this.lblOutput = new JLabel("Output Video File: ");
        paramsPanel.add(this.lblOutput);
        this.txtOutput = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.txtOutput.setBorder(new EtchedBorder());
        paramsPanel.add((Component)this.txtOutput, gbcT);
        this.btnOutput = new JButton("Change...");
        this.lblOutput.setDisplayedMnemonic('v');
        this.lblOutput.setLabelFor(this.btnOutput);
        this.btnOutput.addActionListener(this::chooseOutputFile);
        paramsPanel.add(this.btnOutput);
        JLabel lblResolution = new JLabel("Video Resolution: ");
        paramsPanel.add(lblResolution);
        this.cbResolution = new JComboBox<VideoResolutionType>(VideoResolutionType.values());
        this.cbResolution.setSelectedItem((Object)VideoResolutionType.P_480);
        paramsPanel.add(this.cbResolution);
        paramsPanel.add(new JLabel());
        paramsPanel.add(new JLabel());
        this.chkShow = new JCheckBox("Show output video file when completed", true);
        this.chkShow.setToolTipText("Show the output video file in the file explorer when completed");
        this.chkShow.setMnemonic('s');
        this.chkShow.addActionListener(this::toggleShow);
        GridBagConstraints sgbc = (GridBagConstraints)gbc.clone();
        sgbc.anchor = 21;
        paramsPanel.add((Component)this.chkShow, sgbc);
        paramsPanel.add(new JLabel());
        GridBagConstraints fullWidthGbc = (GridBagConstraints)gbcT.clone();
        fullWidthGbc.gridwidth = 3;
        this.progressBar = new JProgressBar(0, 1000);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("X");
        JPanel pnlProgress = new JPanel(new BorderLayout());
        pnlProgress.add(this.progressBar);
        paramsPanel.add((Component)pnlProgress, fullWidthGbc);
        JPanel buttonsPanel = new JPanel(new GridLayout(1, 2));
        buttonsPanel.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.btnOk = new JButton("Convert");
        this.btnOk.setMnemonic('o');
        this.btnOk.addActionListener(this::ok);
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setMnemonic('c');
        this.btnCancel.addActionListener(this::cancel);
        JPanel pnlOk = new JPanel(new FlowLayout());
        pnlOk.add(this.btnOk);
        JPanel pnlCancel = new JPanel(new FlowLayout());
        pnlCancel.add(this.btnCancel);
        if (Platform.isWindows()) {
            buttonsPanel.add(pnlOk);
            buttonsPanel.add(pnlCancel);
        } else {
            buttonsPanel.add(pnlCancel);
            buttonsPanel.add(pnlOk);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SoundToImageFrame.this.quit();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (SoundToImageFrame.this.inputAudioFile != null) {
                    SoundToImageFrame.this.setInputFileName();
                }
                if (SoundToImageFrame.this.outputVideoFile != null) {
                    SoundToImageFrame.this.setOutputFileName();
                }
            }
        });
        this.getRootPane().setDefaultButton(this.btnOk);
        this.pack();
        this.txtInput.setPreferredSize(this.txtInput.getSize());
        this.txtInput.setText("");
        this.txtOutput.setPreferredSize(this.txtInput.getSize());
        this.txtOutput.setText("");
        pnlProgress.setPreferredSize(pnlProgress.getSize());
        this.setupMinSizeUsingCurrentSize();
        this.progressBar.setVisible(false);
        this.setLocationRelativeTo(null);
    }

    private void setupMinSizeUsingCurrentSize() {
        final Dimension minSize = new Dimension(this.getSize());
        if (AwtTools.getScaleX() == 1.0 && AwtTools.getScaleY() == 1.0) {
            this.setMinimumSize(minSize);
            return;
        }
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean down;
                boolean bl = down = (e.getModifiersEx() & 0x400) != 0;
                if (!down) {
                    Dimension curSize = SoundToImageFrame.this.getSize();
                    if (curSize.width < minSize.width || curSize.height < minSize.height) {
                        SwingUtilities.invokeLater(() -> SoundToImageFrame.this.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height)));
                    }
                }
            }
        });
    }

    private void installDragAndDrop(JLabel txtInput) {
        txtInput.setTransferHandler(new FileTransferHandler(this::importFile));
        txtInput.getDropTarget().setDefaultActions(1);
    }

    private void importFile(File file) {
        this.inputAudioFile = file;
        this.setInputFileName();
        File documents = new JFileChooser().getFileSystemView().getDefaultDirectory();
        File home = documents.getAbsoluteFile().getParentFile();
        File videos = new File(home, "Videos");
        String fileName = this.inputAudioFile.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0) {
            fileName = String.valueOf(fileName.substring(0, lastDot)) + ".mkv";
            File parentFile = videos;
            if (!parentFile.isDirectory()) {
                parentFile = this.inputAudioFile.getAbsoluteFile().getParentFile();
            }
            this.outputVideoFile = new File(parentFile, fileName);
            this.setOutputFileName();
        }
        this.btnOk.requestFocusInWindow();
    }

    private void setInputFileName() {
        String fileName = FileNameLabelCutter.cutFileName(this.inputAudioFile.getAbsolutePath(), this.txtInput, 15, this.lblInput, this.btnInput);
        this.txtInput.setText(fileName);
        this.txtInput.setToolTipText(this.inputAudioFile.getAbsolutePath());
    }

    private void setOutputFileName() {
        String fileName = FileNameLabelCutter.cutFileName(this.outputVideoFile.getAbsolutePath(), this.txtOutput, 15, this.lblOutput, this.btnOutput);
        this.txtOutput.setText(fileName);
        this.txtOutput.setToolTipText(this.outputVideoFile.getAbsolutePath());
    }

    private void chooseInputFile(ActionEvent e) {
        UIManager.put("FileChooser.readOnly", Boolean.TRUE);
        if (this.inputChooser == null) {
            this.inputChooser = new JFileChooser();
            this.inputChooser.addChoosableFileFilter(AudioFileFilter.readInstance());
            this.inputChooser.setFileFilter(AudioFileFilter.readInstance());
            this.inputChooser.setApproveButtonMnemonic('o');
        }
        if (this.inputAudioFile != null) {
            this.inputChooser.setSelectedFile(this.inputAudioFile);
        } else {
            File documents = this.inputChooser.getFileSystemView().getDefaultDirectory();
            File home = documents.getAbsoluteFile().getParentFile();
            File music = new File(home, "Music");
            if (music.isDirectory()) {
                this.inputChooser.setCurrentDirectory(music);
            }
        }
        int result = this.inputChooser.showOpenDialog(this);
        if (result != 0) {
            return;
        }
        File file = this.inputChooser.getSelectedFile();
        if (file == null || !file.isFile()) {
            return;
        }
        this.importFile(file);
    }

    private void chooseOutputFile(ActionEvent e) {
        UIManager.put("FileChooser.readOnly", Boolean.FALSE);
        if (this.outputChooser == null) {
            this.outputChooser = new JFileChooser();
            VideoFileFilter fileFilter = new VideoFileFilter();
            this.outputChooser.addChoosableFileFilter(fileFilter);
            this.outputChooser.setFileFilter(fileFilter);
            this.outputChooser.setApproveButtonMnemonic('o');
        }
        if (this.outputVideoFile != null) {
            this.outputChooser.setSelectedFile(this.outputVideoFile);
        } else {
            File documents = this.outputChooser.getFileSystemView().getDefaultDirectory();
            File home = documents.getAbsoluteFile().getParentFile();
            File videos = new File(home, "Videos");
            if (videos.isDirectory()) {
                this.outputChooser.setCurrentDirectory(videos);
            }
        }
        int result = this.outputChooser.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        this.outputVideoFile = this.outputChooser.getSelectedFile();
        if (this.outputVideoFile == null || this.outputVideoFile.isDirectory()) {
            return;
        }
        this.setOutputFileName();
        this.btnOk.requestFocusInWindow();
    }

    private void toggleShow(ActionEvent e) {
        this.showOutputFileOnCompletion = !this.showOutputFileOnCompletion;
        this.chkShow.setSelected(this.showOutputFileOnCompletion);
    }

    private void ok(ActionEvent e) {
        if (this.inputAudioFile == null) {
            this.reportError("Please choose an input audio file");
            return;
        }
        if (this.outputVideoFile == null || this.outputVideoFile.isDirectory()) {
            this.reportError("Please choose an output video file");
            return;
        }
        if (!this.inputAudioFile.isFile()) {
            this.reportError("File not found: " + this.inputAudioFile.getAbsolutePath());
            return;
        }
        if (this.outputVideoFile.isFile()) {
            int result = AwtTools.showYesNoCancelDialog(this, String.valueOf(this.outputVideoFile.getName()) + " already exists.\nDo you want to replace it?", "Confirm Replace", "Replace", "Don't replace", 1);
            if (result == 1) {
                return;
            }
            if (result == 2) {
                this.cancel(e);
                return;
            }
        }
        this.progressBar.setVisible(true);
        this.setEnabled((JComponent)this.getContentPane(), false);
        this.btnCancel.setEnabled(true);
        this.chkShow.setEnabled(true);
        Thread processThread = new Thread(this::process, "snd2img");
        processThread.start();
    }

    private void process() {
        VideoResolutionType resolution = (VideoResolutionType)((Object)this.cbResolution.getSelectedItem());
        try {
            boolean aborted;
            block9: {
                SoundToImageConverter converter = new SoundToImageConverter(this.inputAudioFile, resolution, this.outputVideoFile);
                this.progress = new ProgressManager(this.progressBar);
                aborted = false;
                try {
                    try {
                        converter.process(this.progress);
                    }
                    catch (OperationAbortedException ex) {
                        aborted = true;
                        this.progress.close();
                        converter.close();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.progress.close();
                    converter.close();
                    throw throwable;
                }
                this.progress.close();
                converter.close();
            }
            this.progress = null;
            if (aborted) {
                SwingUtilities.invokeLater(this::reportAbort);
            } else {
                SwingUtilities.invokeLater(this::reportSuccess);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.reportException(ex);
            SwingUtilities.invokeLater(this::cleanupAfterError);
        }
    }

    private void reportSuccess() {
        this.setEnabled((JComponent)this.getContentPane(), true);
        this.progressBar.setVisible(false);
        JOptionPane.showMessageDialog(this, "Conversion successful!", "snd2img", 1);
        if (this.showOutputFileOnCompletion) {
            SoundToImageFrame.showInSystemExplorer(this.outputVideoFile);
        }
        this.cancel(null);
    }

    private void reportAbort() {
        this.setEnabled((JComponent)this.getContentPane(), true);
        this.progressBar.setVisible(false);
        try {
            Files.delete(this.outputVideoFile.toPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (!this.quit) {
            JOptionPane.showMessageDialog(this, "Conversion aborted!", "snd2img", 2);
        }
    }

    private void cleanupAfterError() {
        this.setEnabled((JComponent)this.getContentPane(), true);
        this.progressBar.setVisible(false);
        if (this.progress != null) {
            this.progress.close();
            this.progress = null;
        }
    }

    private static void showInSystemExplorer(File file) {
        try {
            if (Platform.isWindows()) {
                Runtime.getRuntime().exec("explorer.exe /select,\"" + file.getAbsolutePath().replace("\"", "\\\"") + "\"");
            } else if (Platform.isMacOsX()) {
                Runtime.getRuntime().exec(new String[]{"open", "-R", file.getAbsolutePath()});
            } else {
                if (!Desktop.isDesktopSupported()) {
                    return;
                }
                File folder = file.getAbsoluteFile().getParentFile();
                Desktop.getDesktop().open(folder);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setEnabled(JComponent cmp, boolean value) {
        if ("Title".equals(cmp.getName())) {
            return;
        }
        if (cmp instanceof JProgressBar) {
            return;
        }
        cmp.setEnabled(value);
        Component[] children = cmp.getComponents();
        if (children == null) {
            return;
        }
        Component[] componentArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Component child = componentArray[n2];
            Component component = child;
            if (component instanceof JComponent) {
                void jcmp;
                JComponent cfr_ignored_0 = (JComponent)component;
                JComponent cfr_ignored_1 = (JComponent)component;
                this.setEnabled((JComponent)jcmp, value);
            }
            ++n2;
        }
    }

    private void cancel(ActionEvent e) {
        if (this.progress != null) {
            this.progress.interrupt();
            return;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void quit() {
        this.quit = true;
        if (this.progress != null) {
            this.progress.interrupt();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void reportException(Exception ex) {
        SwingUtilities.invokeLater(() -> {
            String message = ex.getLocalizedMessage();
            if (StringUtils.isBlank(message)) {
                message = ex.getClass().getSimpleName();
            }
            JOptionPane.showMessageDialog(this, message, "Error", 0);
        });
    }

    private void reportError(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }
}

