/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.gui.icon;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.corebounce.common.gui.AwtTools;

public class JMultiImageIcon
extends JComponent {
    private final Collection<ImageIcon> icons;
    private final int width;
    private final int height;

    public JMultiImageIcon(ImageIcon icon, int width, int height) {
        this(Collections.singleton(icon), width, height);
    }

    public JMultiImageIcon(Collection<ImageIcon> icons, int width, int height) {
        this.icons = icons;
        this.width = width;
        this.height = height;
        this.setPreferredSize(new Dimension(this.width, this.height));
    }

    private ImageIcon pickBestIcon() {
        double displayWidth = (double)this.width * AwtTools.getScaleX(this);
        double displayHeight = (double)this.height * AwtTools.getScaleY(this);
        ImageIcon best = null;
        ImageIcon biggest = null;
        for (ImageIcon icon : this.icons) {
            if ((double)icon.getIconWidth() >= displayWidth && (double)icon.getIconHeight() >= displayHeight) {
                if (best != null) {
                    double bestScore = (double)best.getIconWidth() - displayWidth + ((double)best.getIconHeight() - displayHeight);
                    double thisScore = (double)icon.getIconWidth() - displayWidth + ((double)icon.getIconHeight() - displayHeight);
                    if (thisScore < bestScore) {
                        best = icon;
                    }
                } else {
                    best = icon;
                }
            }
            if (biggest != null) {
                if (icon.getIconWidth() * icon.getIconHeight() <= biggest.getIconWidth() * biggest.getIconHeight()) continue;
                biggest = icon;
                continue;
            }
            biggest = icon;
        }
        if (best != null) {
            return best;
        }
        return biggest;
    }

    @Override
    protected void paintComponent(Graphics g0) {
        Graphics2D g = (Graphics2D)g0.create();
        ImageIcon icon = this.pickBestIcon();
        AwtTools.setupHighQuality(g);
        g.scale((double)this.width / (double)icon.getIconWidth(), (double)this.height / (double)icon.getIconHeight());
        g.drawImage(icon.getImage(), 0, 0, null);
        g.dispose();
    }
}

