/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.install;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

public class AntBuilder {
    public static File executeAntBuild(String projectName, String antFilePath, String expectedTargetFile) throws IOException {
        File workspace = new File("").getAbsoluteFile().getParentFile();
        File project = new File(workspace, projectName);
        File antFile = new File(project, antFilePath);
        if (!antFile.isFile()) {
            throw new FileNotFoundException(antFile.toString());
        }
        File targetFile = new File(project, expectedTargetFile);
        if (targetFile.exists()) {
            Files.delete(targetFile.toPath());
        }
        Project p = new Project();
        p.setUserProperty("ant.file", antFile.getAbsolutePath());
        p.init();
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        p.addReference("ant.projectHelper", (Object)helper);
        helper.parse(p, (Object)antFile);
        p.executeTarget(p.getDefaultTarget());
        if (!targetFile.isFile()) {
            throw new IllegalStateException("File " + targetFile.toString() + " was not created");
        }
        return targetFile;
    }
}

