/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.install;

import ch.tachyon.sonics.install.utils.JarSigner;
import ch.tachyon.sonics.install.windows.WindowsSigner;
import ch.tachyon.sonics.snd2img.install.AntBuilder;
import ch.tachyon.sonics.snd2img.install.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.corebounce.common.io.IOUtils;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.StringUtils;

public class Installer {
    private static final String JDK_WINDOWS_64_PATH = "C:\\Users\\Nicolas Juillerat\\Documents\\Apps\\OpenJDK17U-jdk_x64_windows_hotspot_17.0.5_8\\jdk-17.0.5+8";
    private static final String BUILD_DIR = "C:\\Users\\Nicolas Juillerat\\Desktop\\Temp\\SoundToImage\\build";
    private static final String TEMP_DIR = "C:\\Users\\Nicolas Juillerat\\Desktop\\Temp\\SoundToImage\\temp";
    private static final String CERT_CHAIN_PATH = "C:\\Users\\Nicolas Juillerat\\Documents\\SSL.com\\yubikey.p7b";

    public static void runCommand(List<String> command) throws IOException, InterruptedException {
        Installer.runCommand(null, command);
    }

    static void runCommand(File location, List<String> command) throws IOException, InterruptedException {
        System.out.println("Running: " + Installer.command2string(command));
        ProcessBuilder builder = new ProcessBuilder(command);
        if (location != null) {
            builder.directory(location);
        }
        builder.inheritIO();
        Process process = builder.start();
        process.waitFor(10L, TimeUnit.MINUTES);
        int exitCode = process.exitValue();
        System.out.println("Exit code: " + exitCode);
        if (exitCode != 0) {
            throw new IllegalStateException();
        }
    }

    private static String command2string(List<String> command) {
        StringBuilder result = new StringBuilder();
        for (String item : command) {
            if (result.length() > 0) {
                result.append(" ");
            }
            if (Platform.isWindows()) {
                if (item.contains(" ")) {
                    result.append("\"" + item + "\"");
                    continue;
                }
                result.append(item);
                continue;
            }
            result.append(item.replace(" ", "\\ "));
        }
        return result.toString();
    }

    public static File createCustomJre(File jdk, File jarFile) throws IOException, InterruptedException {
        String accessibility;
        File jdepsExe = new File(jdk, "bin" + File.separator + (Platform.isWindows() ? "jdeps.exe" : "jdeps"));
        ProcessBuilder builder = new ProcessBuilder(Arrays.asList(jdepsExe.getAbsolutePath(), "--print-module-deps", "--ignore-missing-deps", jarFile.getAbsolutePath()));
        builder.redirectOutput(ProcessBuilder.Redirect.PIPE);
        Process process = builder.start();
        InputStream input = process.getInputStream();
        byte[] output = IOUtils.readAll(input);
        String dependencies = new String(output, StandardCharsets.UTF_8);
        int result = process.waitFor();
        System.out.println("\nExit code: " + result);
        if (result != 0) {
            throw new IllegalStateException();
        }
        if (!(dependencies = dependencies.trim()).contains(accessibility = "jdk.accessibility")) {
            dependencies = String.valueOf(dependencies) + "," + accessibility;
        }
        System.out.println("Dependencies: " + dependencies);
        File jre = Files.createTempDirectory("jre", new FileAttribute[0]).toFile();
        Files.delete(jre.toPath());
        File jlinkExe = new File(new File(jdk, "bin"), Platform.isWindows() ? "jlink.exe" : "jlink");
        String jmodsPath = String.valueOf(jdk.getAbsolutePath()) + File.separator + "jmods";
        builder = new ProcessBuilder(Arrays.asList(jlinkExe.getAbsolutePath(), "--no-header-files", "--no-man-pages", "--module-path", jmodsPath, "--add-modules", dependencies, "--output", jre.getAbsolutePath()));
        System.out.println(builder.command());
        builder.inheritIO();
        process = builder.start();
        result = process.waitFor();
        System.out.println("\nExit code: " + result);
        if (result != 0) {
            throw new IllegalStateException();
        }
        if (Platform.isWindows()) {
            File jreConf = new File(jre, "conf");
            File apFile = new File(jreConf, "accessibility.properties");
            InputStream apInput = Installer.class.getResourceAsStream("accessibility.properties");
            byte[] data = IOUtils.readAll(apInput);
            Files.write(apFile.toPath(), data, new OpenOption[0]);
            IOUtils.close(apInput);
        }
        return jre;
    }

    public static File createInstaller(File jdk, File jre, File jarFile, File targetDir, File tempDir) throws IOException, InterruptedException {
        File inputDir = Files.createTempDirectory("snd2img", new FileAttribute[0]).toFile();
        Files.copy(jarFile.toPath(), inputDir.toPath().resolve(jarFile.getName()), new CopyOption[0]);
        File ffmpeg = new File("app" + File.separator + "ffmpeg.exe");
        Files.copy(ffmpeg.toPath(), inputDir.toPath().resolve(ffmpeg.getName()), new CopyOption[0]);
        File licenseFile = new File("License.rtf");
        File iconFile = new File("snd2img.ico");
        File jpackageExe = new File(jdk, "bin" + File.separator + (Platform.isWindows() ? "jpackage.exe" : "jpackage"));
        ArrayList<String> command = new ArrayList<String>();
        command.add(jpackageExe.getAbsolutePath());
        command.add("--verbose");
        command.add("--app-version");
        command.add("0.9.3");
        command.add("--copyright");
        command.add("Copyright 2024 Nicolas Juillerat");
        command.add("--description");
        command.add("Sound To Image");
        command.add("--license-file");
        command.add(licenseFile.getAbsolutePath());
        command.add("--icon");
        command.add(iconFile.getAbsolutePath());
        command.add("--name");
        command.add("snd2img");
        command.add("--dest");
        command.add(targetDir.getAbsolutePath());
        command.add("--temp");
        command.add(tempDir.getAbsolutePath());
        command.add("--vendor");
        command.add("Nicolas Juillerat");
        command.add("--runtime-image");
        command.add(jre.getAbsolutePath());
        command.add("--input");
        command.add(inputDir.getAbsolutePath());
        command.add("--main-jar");
        command.add("snd2img.jar");
        command.add("--install-dir");
        command.add("snd2img");
        if (Platform.isWindows()) {
            command.add("--type");
            command.add("msi");
            command.add("--win-upgrade-uuid");
            command.add("4e09407a-f1fe-4fe9-9489-aa36a5bc6989");
            command.add("--win-menu");
            command.add("--win-menu-group");
            command.add("Pitchtech");
            command.add("--win-shortcut");
            command.add("--win-shortcut-prompt");
        }
        Installer.runCommand(command);
        FileUtils.deleteDirectory(inputDir.toPath());
        File exe = new File(targetDir, "snd2img-0.9.3.msi");
        if (!exe.isFile()) {
            throw new IllegalStateException();
        }
        return exe;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Creating jar file...");
        File jarFile = AntBuilder.executeAntBuild("ch.tachyon.sonics.snd2img", "snd2img.ant", "snd2img.jar");
        System.out.println("Signing " + jarFile + "...");
        System.out.print("Token PIN [blank to skip]: ");
        System.out.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        String password = reader.readLine();
        if (StringUtils.isNotBlank(password)) {
            JarSigner.signJarFileUsingToken((Path)jarFile.toPath(), (Path)Path.of(CERT_CHAIN_PATH, new String[0]), (String)password);
        } else {
            System.out.println("Not signing");
        }
        File jdk = new File(JDK_WINDOWS_64_PATH);
        System.out.println("Creating custom jre...");
        File jre = Installer.createCustomJre(jdk, jarFile);
        System.out.println("Creating installer...");
        File tempDir = new File(TEMP_DIR);
        FileUtils.deleteDirectory(tempDir.toPath());
        tempDir.mkdir();
        File targetDir = new File(BUILD_DIR);
        File installer = Installer.createInstaller(jdk, jre, jarFile, targetDir, tempDir);
        if (StringUtils.isNotBlank(password)) {
            System.out.println("Signing installer...");
            WindowsSigner.signFilesUsingToken((String)password, (String)"snd2img", (Path[])new Path[]{installer.toPath()});
        }
        System.out.println("Cleaning up");
        FileUtils.deleteDirectory(jre.toPath());
        Files.copy(jarFile.toPath(), installer.getParentFile().toPath().resolve(jarFile.getName()), StandardCopyOption.REPLACE_EXISTING);
        System.out.println("Installer path: " + installer.getAbsolutePath());
    }
}

