/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.utils;

public class EtrEstimator {
    private final long startTime;
    private long lastRemaining;
    private long lastRefreshTime;

    public EtrEstimator() {
        this.lastRefreshTime = this.startTime = System.currentTimeMillis();
    }

    public String getEtr(String text, double percent) {
        StringBuilder message = new StringBuilder();
        message.append(text);
        long now = System.currentTimeMillis();
        long elapsedSinceLast = now - this.lastRefreshTime;
        this.lastRefreshTime = now;
        int intPercent = (int)percent;
        if (intPercent > 0 && percent > 0.0) {
            if (message.length() > 0) {
                message.append(" - ");
            }
            long elapsed = now - this.startTime;
            long estimated = (long)((double)elapsed * 100.0 / percent);
            long remaining = estimated - elapsed;
            long remaining0 = this.lastRemaining - elapsedSinceLast;
            if (remaining > 0L) {
                double ratio;
                if (remaining0 > 0L && Math.abs(remaining - remaining0) < 1000L) {
                    remaining = remaining0;
                }
                if ((ratio = (double)this.lastRemaining / (double)remaining) >= 0.8 && ratio < 1.25) {
                    remaining = Math.min(remaining, this.lastRemaining);
                }
            }
            if (remaining < 0L) {
                remaining = 0L;
            }
            this.lastRemaining = remaining;
            long seconds = (remaining + 999L) / 1000L;
            int secs = (int)(seconds % 60L);
            int mins = (int)(seconds / 60L % 60L);
            int hours = (int)(seconds / 3600L % 24L);
            long days = seconds / 86400L;
            if (days > 0L) {
                message.append(days);
                message.append("d");
            }
            if (days > 0L || hours > 0) {
                message.append(hours);
                message.append(":");
            }
            message.append(mins / 10);
            message.append(mins % 10);
            message.append(":");
            message.append(secs / 10);
            message.append(secs % 10);
        }
        return message.toString();
    }
}

