/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.utils;

import ch.tachyon.sonics.snd2img.VideoResolutionType;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.corebounce.common.utils.Platform;

public class FFmpeg {
    private File commandOutputFile;
    private String commandLine;
    private Process process;

    public OutputStream createFfmpegCommand(String ffmpegPath, File inputAudioFile, File outputVideoFile, VideoResolutionType resolution) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(ffmpegPath);
        command.add("-f");
        command.add("image2pipe");
        command.add("-framerate");
        command.add(String.valueOf(25));
        command.add("-s");
        command.add(String.valueOf(String.valueOf(resolution.getWidth())) + "x" + String.valueOf(resolution.getHeight()));
        command.add("-i");
        command.add("-");
        command.add("-i");
        command.add(inputAudioFile.getAbsolutePath());
        command.add("-pix_fmt");
        command.add("yuv420p");
        command.add("-vb");
        double mBps = (double)resolution.getkBps() / 1000.0;
        DecimalFormat f = new DecimalFormat("#0.##");
        command.add(String.valueOf(f.format(mBps)) + "M");
        command.add("-c:a");
        command.add("libopus");
        command.add("-vbr");
        command.add("on");
        command.add("-compression_level");
        command.add("10");
        command.add("-b:a");
        command.add("160000");
        command.add("-strict");
        command.add("-2");
        command.add("-shortest");
        command.add(outputVideoFile.getAbsolutePath());
        this.commandOutputFile = File.createTempFile("ffmpeg", ".out");
        this.commandLine = FFmpeg.command2string(command);
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        builder.redirectOutput(this.commandOutputFile);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        this.process = builder.start();
        return this.process.getOutputStream();
    }

    public void waitFor() throws InterruptedException, IOException {
        this.process.waitFor(1L, TimeUnit.MINUTES);
        int exitCode = this.process.exitValue();
        if (exitCode != 0) {
            System.err.println("There was an error creating the video stream.");
            System.err.println("Command line: " + this.commandLine);
            System.err.println("Output:");
            String output = Files.readString(this.commandOutputFile.toPath());
            System.err.println(output);
        }
    }

    private static String command2string(List<String> command) {
        StringBuilder result = new StringBuilder();
        for (String item : command) {
            if (result.length() > 0) {
                result.append(" ");
            }
            if (item.contains(" ")) {
                result.append("\"" + item + "\"");
                continue;
            }
            result.append(item);
        }
        return result.toString();
    }

    public static String getFfmpegPath() {
        File result = new File("app" + File.separator + "ffmpeg" + (Platform.isWindows() ? ".exe" : ""));
        if (result.isFile()) {
            return result.getAbsolutePath();
        }
        return "ffmpeg";
    }
}

