/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.snd2img.utils;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImageUtils {
    static {
        ImageIO.setUseCache(false);
    }

    public static BufferedImage byteArrayToImage(byte[] frameBuffer, int width, int height) {
        DataBufferByte buffer = new DataBufferByte(frameBuffer, frameBuffer.length);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        ComponentSampleModel sampleModel = new ComponentSampleModel(0, width, height, 3, width * 3, nArray);
        Raster raster = Raster.createRaster(sampleModel, buffer, null);
        BufferedImage image = new BufferedImage(width, height, 5);
        image.setData(raster);
        return image;
    }

    public static void saveImage(BufferedImage image, OutputStream output) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("BMP").next();
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(0);
        ImageOutputStream ios = ImageIO.createImageOutputStream(output);
        writer.setOutput(ios);
        writer.write(null, new IIOImage(image, null, null), param);
        writer.dispose();
    }
}

