/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.audio.file.AudioFileFormatEx;
import ch.tachyon.tunnel.audio.file.AudioFileTypes;
import ch.tachyon.tunnel.audio.file.AudioInputStreamSource;
import ch.tachyon.tunnel.audio.file.AudioSourceInputStream;
import ch.tachyon.tunnel.audio.file.RandomFileProgressInputStream;
import ch.tachyon.tunnel.audio.utils.IOUtils;
import ch.tachyon.tunnel.audio.utils.IProgressMonitor;
import ch.tachyon.tunnel.audio.utils.OperationAbortedException;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.utils.Debug;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileIO {
    public static IMultiChanAudioSource createAudioSource(File file) throws IOException, UnsupportedAudioFileException {
        RandomFileProgressInputStream input = new RandomFileProgressInputStream(file);
        return AudioFileIO.createAudioSource(file.getName(), (InputStream)((Object)input));
    }

    public static IMultiChanAudioSource createAudioSource(File file, IProgressMonitor progress) throws IOException, UnsupportedAudioFileException {
        RandomFileProgressInputStream input = new RandomFileProgressInputStream(file, progress);
        return AudioFileIO.createAudioSource(file.getName(), (InputStream)((Object)input));
    }

    public static IMultiChanAudioSource createAudioSource(String fileName, InputStream stream) throws IOException, UnsupportedAudioFileException {
        AudioFileTypes aft = AudioFileTypes.instance();
        AudioInputStream audioInput = aft.getAudioInputStream(fileName, stream);
        return new AudioInputStreamSource(audioInput);
    }

    private static long getNbFrames(AudioFileFormat fileFormat) {
        if (fileFormat instanceof AudioFileFormatEx) {
            return ((AudioFileFormatEx)fileFormat).getFrameLengthLong();
        }
        return fileFormat.getFrameLength();
    }

    private static AudioFormat saveFormatOf(AudioFileFormat fileFormat) {
        AudioFormat format = fileFormat.getFormat();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(fileFormat.properties());
        properties.putAll(format.properties());
        AudioFormat result = new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), format.getChannels(), format.getFrameSize(), format.getFrameRate(), format.isBigEndian(), properties);
        return result;
    }

    public static void saveAudioFile(IMultiChanAudioSource audioSource, File outputFile, AudioFileFormat saveFormat, IProgressMonitor progress) throws IOException {
        AudioInputStream input = AudioSourceInputStream.createAudioInputStream(audioSource, AudioFileIO.saveFormatOf(saveFormat), progress, AudioFileIO.getNbFrames(saveFormat));
        try {
            AudioFileTypes.write(input, saveFormat.getType(), outputFile);
        }
        finally {
            IOUtils.close(audioSource);
            input.close();
        }
    }

    public static void saveAudioFile(IMultiChanAudioSource audioSource, OutputStream target, AudioFileFormat saveFormat, IProgressMonitor progress) throws IOException, OperationAbortedException {
        if (AudioFileIO.getNbFrames(saveFormat) == -1L && !(target instanceof FileOutputStream) && !saveFormat.getType().equals(AudioFileFormat.Type.AU)) {
            throw new IllegalArgumentException("Writing to a stream with unspecified length is not allowed");
        }
        AudioSourceInputStream source = AudioSourceInputStream.createAudioSourceInputStream(audioSource, saveFormat.getFormat(), progress, AudioFileIO.getNbFrames(saveFormat));
        AudioInputStream input = new AudioInputStream(source, AudioFileIO.saveFormatOf(saveFormat), AudioFileIO.getNbFrames(saveFormat));
        try {
            AudioFileTypes.write(input, saveFormat.getType(), target);
        }
        finally {
            IOUtils.close(audioSource);
            target.close();
            input.close();
        }
        OperationAbortedException abortion = source.aborted();
        if (abortion != null) {
            throw abortion;
        }
    }

    public static InputStream convertToFormat(IMultiChanAudioSource audioSource, final AudioFileFormat saveFormat, IProgressMonitor progress) throws IOException {
        if (AudioFileIO.getNbFrames(saveFormat) == -1L && !saveFormat.getType().equals(AudioFileFormat.Type.AU)) {
            throw new IllegalArgumentException("Writing to a stream with unspecified length is not allowed");
        }
        AudioSourceInputStream source = AudioSourceInputStream.createAudioSourceInputStream(audioSource, saveFormat.getFormat(), progress, AudioFileIO.getNbFrames(saveFormat));
        final AudioInputStream input = new AudioInputStream(source, AudioFileIO.saveFormatOf(saveFormat), AudioFileIO.getNbFrames(saveFormat));
        final PipedOutputStream pipeOut = new PipedOutputStream();
        PipedInputStream pipeIn = new PipedInputStream(pipeOut);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AudioFileTypes.write(input, saveFormat.getType(), pipeOut);
                    pipeOut.flush();
                    pipeOut.close();
                }
                catch (IOException ex) {
                    Debug.error(ex);
                }
            }
        }, "AudioFileIO.pipe").start();
        return new BufferedInputStream(pipeIn, 4096);
    }

    public static void close(Object streamWrapper) throws IOException {
        if (streamWrapper instanceof Closeable) {
            ((Closeable)streamWrapper).close();
        }
    }
}

