/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.audio.file.AudioFileFormatEx;
import ch.tachyon.tunnel.audio.file.AudioFileIO;
import ch.tachyon.tunnel.audio.file.AudioInputStreamSource;
import ch.tachyon.tunnel.audio.file.IFileFormatDetector;
import ch.tachyon.tunnel.audio.file.RandomFileProgressInputStream;
import ch.tachyon.tunnel.audio.utils.IOUtils;
import ch.tachyon.tunnel.audio.utils.IProgressMonitor;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.utils.Debug;
import ch.tachyon.tunnel.common.utils.Pair;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.tritonus.sampled.file.AiffAudioFileWriter;
import org.tritonus.sampled.file.AuAudioFileWriter;
import org.tritonus.sampled.file.WaveAudioFileWriter;
import org.tritonus.share.sampled.Encodings;
import org.tritonus.share.sampled.file.TAudioFileFormat;

public class AudioFileTypes {
    private static final String SERVICE_RESOURCE = "META-INF/services/tachyon.tunnel.audio.file.FileReader";
    private static final ThreadLocal<AudioFileTypes> instances = new ThreadLocal();
    private static final Lock readLock = new ReentrantLock(true);
    private Map<String, Collection<String>> ext2fileReader = new LinkedHashMap<String, Collection<String>>();
    private Map<String, String> ext2Type = new LinkedHashMap<String, String>();
    private Map<String, AudioFileFormat.Type> ext2writeType = new LinkedHashMap<String, AudioFileFormat.Type>();
    private Set<String> threadUnsafeProviders = new HashSet<String>();
    private boolean javaSoundFallback = true;

    private AudioFileTypes() {
    }

    public static synchronized AudioFileTypes instance() {
        AudioFileTypes result = instances.get();
        if (result == null) {
            result = new AudioFileTypes();
            instances.set(result);
            result.init();
        }
        return result;
    }

    protected void init() {
        AudioFileFormat.Type[] writeTypes;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> metaInfs = cl.getResources(SERVICE_RESOURCE);
            while (metaInfs.hasMoreElements()) {
                URL metaInf = metaInfs.nextElement();
                final ArrayList props = new ArrayList();
                Properties propParser = new Properties(){

                    @Override
                    public synchronized Object put(Object key, Object value) {
                        props.add(new Pair<Object, Object>(key, value));
                        return super.put(key, value);
                    }
                };
                try {
                    IOUtils.loadUtf8Properties(metaInf.openStream(), propParser);
                    boolean threadSafe = true;
                    ArrayList<String> foundClassNames = new ArrayList<String>();
                    for (Pair pair : props) {
                        String ext;
                        String key = (String)pair.getFirst();
                        if (key.startsWith("loader.")) {
                            ext = key.substring("loader".length()).toLowerCase();
                            String className = (String)pair.getSecond();
                            if (className == null || "".equals(className.trim()) || "".equals(ext.substring(1).trim())) continue;
                            try {
                                Class.forName(className, false, cl);
                                Collection<String> classNames = this.ext2fileReader.get(ext);
                                if (classNames == null) {
                                    classNames = new ArrayList<String>();
                                    this.ext2fileReader.put(ext, classNames);
                                }
                                classNames.add(className);
                                foundClassNames.add(className);
                            }
                            catch (Throwable ex) {
                                Debug.warn("Cannot load JavaSound FileReader {0} for extension {1}", className, ext);
                                Debug.warn(ex);
                            }
                            continue;
                        }
                        if (key.startsWith("type.")) {
                            ext = key.substring("type".length()).toLowerCase();
                            String type = (String)pair.getSecond();
                            if (type == null || type.trim().equals("") || ext.substring(1).trim().equals("")) continue;
                            this.ext2Type.put(ext, type);
                            continue;
                        }
                        if (!key.equals("thread.safe")) continue;
                        boolean bl = threadSafe = !"false".equalsIgnoreCase((String)pair.getSecond());
                    }
                    if (threadSafe) continue;
                    this.threadUnsafeProviders.addAll(foundClassNames);
                }
                catch (IOException ex) {
                    Debug.warn(ex);
                }
                catch (Exception ex) {
                    Debug.error(ex);
                }
            }
        }
        catch (IOException ex) {
            Debug.warn(ex);
        }
        Iterator<String> iter = this.ext2Type.keySet().iterator();
        while (iter.hasNext()) {
            String ext = iter.next();
            if (this.ext2fileReader.containsKey(ext)) continue;
            iter.remove();
        }
        if (!this.ext2Type.containsKey(".aiff")) {
            this.ext2Type.put(".aiff", "AIFF/AIFC");
        }
        if (!this.ext2Type.containsKey(".aifc")) {
            this.ext2Type.put(".aifc", "AIFF/AIFC");
        }
        if (!this.ext2Type.containsKey(".aif")) {
            this.ext2Type.put(".aif", "AIFF/AIFC");
        }
        if (!this.ext2Type.containsKey(".wav")) {
            this.ext2Type.put(".wav", "WAVE");
        }
        if (!this.ext2Type.containsKey(".au")) {
            this.ext2Type.put(".au", "AU");
        }
        if ((writeTypes = AudioSystem.getAudioFileTypes()) != null) {
            AudioFileFormat.Type[] typeArray = writeTypes;
            int n = writeTypes.length;
            int n2 = 0;
            while (n2 < n) {
                AudioFileFormat.Type type = typeArray[n2];
                String extension = type.getExtension();
                if (extension != null) {
                    if (!extension.startsWith(".")) {
                        extension = "." + extension;
                    }
                    this.ext2writeType.put(extension, type);
                }
                ++n2;
            }
        }
        if (!this.ext2writeType.containsKey(".aiff")) {
            this.ext2writeType.put(".aiff", AudioFileFormat.Type.AIFF);
        }
        if (!this.ext2writeType.containsKey(".aifc")) {
            this.ext2writeType.put(".aifc", AudioFileFormat.Type.AIFC);
        }
        if (!this.ext2writeType.containsKey(".aif")) {
            this.ext2writeType.put(".aif", AudioFileFormat.Type.AIFF);
        }
        if (!this.ext2writeType.containsKey(".wav")) {
            this.ext2writeType.put(".wav", AudioFileFormat.Type.WAVE);
        }
        if (!this.ext2writeType.containsKey(".au")) {
            this.ext2writeType.put(".au", AudioFileFormat.Type.AU);
        }
    }

    public boolean isJavaSoundFallback() {
        return this.javaSoundFallback;
    }

    public void setJavaSoundFallback(boolean javaSoundFallback) {
        this.javaSoundFallback = javaSoundFallback;
    }

    public Collection<String> getSupportedReadTypes() {
        return new TreeSet<String>(this.ext2Type.values());
    }

    public Collection<String> getSupportedWriteTypes() {
        TreeSet<String> result = new TreeSet<String>();
        for (String ext : this.ext2writeType.keySet()) {
            String type = this.ext2Type.get(ext);
            if (type == null) {
                type = ext.substring(1).toUpperCase();
            }
            result.add(type);
        }
        return result;
    }

    public Collection<String> getExtensionsForType(String type) {
        ArrayList<String> result = new ArrayList<String>();
        for (String ext : this.ext2Type.keySet()) {
            String extType = this.ext2Type.get(ext);
            if (!extType.equals(type)) continue;
            result.add(ext);
        }
        return result;
    }

    public Collection<String> getSupportedReadExtensions() {
        return Collections.unmodifiableSet(this.ext2Type.keySet());
    }

    public Collection<String> getSupportedWriteExtensions() {
        return Collections.unmodifiableSet(this.ext2writeType.keySet());
    }

    public AudioFormat.Encoding getEncodingFor(AudioFormat.Encoding encoding, int bitDepth) {
        if (encoding != null) {
            if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED) && (bitDepth == 8 || bitDepth == 16 || bitDepth == 24 || bitDepth == 32)) {
                return AudioFormat.Encoding.PCM_SIGNED;
            }
            if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED) && bitDepth == 8) {
                return AudioFormat.Encoding.PCM_UNSIGNED;
            }
            if (encoding.equals(Encodings.PCM_IEEE_FLOAT) && (bitDepth == 32 || bitDepth == 64)) {
                return Encodings.PCM_IEEE_FLOAT;
            }
        }
        if (bitDepth == 8) {
            return AudioFormat.Encoding.PCM_UNSIGNED;
        }
        if (bitDepth == 16 || bitDepth == 24) {
            return AudioFormat.Encoding.PCM_SIGNED;
        }
        if (bitDepth == 32 || bitDepth == 64) {
            return Encodings.PCM_IEEE_FLOAT;
        }
        return null;
    }

    public String getAudioFileType(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        String ext = fileName.substring(lastDot).toLowerCase();
        return this.ext2Type.get(ext);
    }

    public String getAudioFileType(AudioFileFormat.Type fileType) {
        for (Map.Entry<String, AudioFileFormat.Type> entry : this.ext2writeType.entrySet()) {
            if (!entry.getValue().equals(fileType)) continue;
            String ext = entry.getKey();
            return this.ext2Type.get(ext);
        }
        return null;
    }

    public AudioFileFormat.Type getWritableType(String type) {
        for (String ext : this.getExtensionsForType(type)) {
            AudioFileFormat.Type result = this.ext2writeType.get(ext);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public AudioFileFormat.Type getWritableType4ext(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return null;
        }
        String extension = fileName.substring(lastDot);
        return this.ext2writeType.get(extension);
    }

    public AudioFileFormat.Type getPlatformDefaultType() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("windows")) {
            return AudioFileFormat.Type.WAVE;
        }
        if (osName.contains("mac")) {
            return AudioFileFormat.Type.AIFF;
        }
        return AudioFileFormat.Type.AU;
    }

    protected List<AudioFileReader> getAudioFileReaders(String fileName, AtomicBoolean threadSafe) throws IOException {
        String extension;
        Collection<String> fileReaderClassNames;
        ArrayList<AudioFileReader> result = new ArrayList<AudioFileReader>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0 && (fileReaderClassNames = this.ext2fileReader.get(extension = fileName.substring(lastDot).toLowerCase())) != null) {
            for (String fileReaderClassName : fileReaderClassNames) {
                try {
                    Class<?> clazz = Class.forName(fileReaderClassName, true, classLoader);
                    AudioFileReader reader = (AudioFileReader)clazz.newInstance();
                    threadSafe.set(!this.threadUnsafeProviders.contains(fileReaderClassName));
                    result.add(reader);
                }
                catch (Exception ex) {
                    Debug.error(ex);
                }
            }
        }
        return result;
    }

    AudioInputStream getAudioInputStream(String fileName, InputStream fileInput) throws IOException, UnsupportedAudioFileException {
        AtomicBoolean threadSafe = new AtomicBoolean();
        if (fileName != null) {
            for (AudioFileReader reader : this.getAudioFileReaders(fileName, threadSafe)) {
                try {
                    if (!threadSafe.get()) {
                        readLock.lock();
                    }
                    AudioInputStream audioInputStream = reader.getAudioInputStream(fileInput);
                    return audioInputStream;
                }
                catch (IOException ex) {
                    Debug.warn(ex);
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                }
                finally {
                    if (!threadSafe.get()) {
                        readLock.unlock();
                    }
                }
            }
        }
        if (!this.javaSoundFallback) {
            throw new UnsupportedAudioFileException("Unknown audio file format");
        }
        return AudioSystem.getAudioInputStream(fileInput);
    }

    static int write(AudioInputStream stream, AudioFileFormat.Type fileType, OutputStream out) throws IOException {
        if (fileType.equals(AudioFileFormat.Type.WAVE)) {
            WaveAudioFileWriter writer = new WaveAudioFileWriter();
            return writer.write(stream, fileType, out);
        }
        if (fileType.equals(AudioFileFormat.Type.AIFF) || fileType.equals(AudioFileFormat.Type.AIFC)) {
            AiffAudioFileWriter writer = new AiffAudioFileWriter();
            return writer.write(stream, fileType, out);
        }
        if (fileType.equals(AudioFileFormat.Type.AU)) {
            AuAudioFileWriter writer = new AuAudioFileWriter();
            return writer.write(stream, fileType, out);
        }
        return AudioSystem.write(stream, fileType, out);
    }

    static int write(AudioInputStream stream, AudioFileFormat.Type fileType, File outputFile) throws IOException {
        if (fileType.equals(AudioFileFormat.Type.WAVE)) {
            WaveAudioFileWriter writer = new WaveAudioFileWriter();
            return writer.write(stream, fileType, outputFile);
        }
        if (fileType.equals(AudioFileFormat.Type.AIFF) || fileType.equals(AudioFileFormat.Type.AIFC)) {
            AiffAudioFileWriter writer = new AiffAudioFileWriter();
            return writer.write(stream, fileType, outputFile);
        }
        if (fileType.equals(AudioFileFormat.Type.AU)) {
            AuAudioFileWriter writer = new AuAudioFileWriter();
            return writer.write(stream, fileType, outputFile);
        }
        return AudioSystem.write(stream, fileType, outputFile);
    }

    public AudioFileFormat getAudioFileFormat(File file, boolean forceComputeLength) throws IOException, UnsupportedAudioFileException {
        return this.getAudioFileFormat(file, forceComputeLength, null);
    }

    public AudioFileFormat getAudioFileFormat(File file, boolean forceComputeLength, IProgressMonitor progress) throws IOException, UnsupportedAudioFileException {
        return this.getAudioFileFormat(file, null, forceComputeLength, progress);
    }

    public AudioFileFormat getAudioFileFormat(File file, IFileFormatDetector detector, boolean forceComputeLength, IProgressMonitor progress) throws IOException, UnsupportedAudioFileException {
        RandomFileProgressInputStream fileInput = new RandomFileProgressInputStream(file, progress);
        AudioFileFormat result = this.getAudioFileFormat(file.getName(), (InputStream)((Object)fileInput));
        ((InputStream)((Object)fileInput)).close();
        if (detector != null) {
            try {
                result = this.applyDetector(file, detector, result);
            }
            catch (IOException iOException) {
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                // empty catch block
            }
        }
        if (result.getFrameLength() == -1) {
            if (result instanceof TAudioFileFormat) {
                TAudioFileFormat taff = (TAudioFileFormat)result;
                if (taff.getFrameLengthEx() != -1L) {
                    result = new AudioFileFormatEx(result.getType(), result.getFormat(), taff.getFrameLengthEx(), result.properties());
                } else if (forceComputeLength) {
                    result = this.forceComputeLength(file, progress, result);
                }
            } else if (forceComputeLength) {
                result = this.forceComputeLength(file, progress, result);
            }
        } else if (result.getFrameLength() < 0) {
            result = new AudioFileFormatEx(result.getType(), result.getFormat(), (long)result.getFrameLength() & 0xFFFFFFL, result.properties());
        }
        return result;
    }

    public AudioFileFormatEx getAudioFileFormatExactLength(File file, IProgressMonitor progress) throws IOException, UnsupportedAudioFileException {
        RandomFileProgressInputStream fileInput = new RandomFileProgressInputStream(file, progress);
        AudioFileFormat result = this.getAudioFileFormat(file.getName(), (InputStream)((Object)fileInput));
        ((InputStream)((Object)fileInput)).close();
        result = this.forceComputeLength(file, progress, result);
        return (AudioFileFormatEx)result;
    }

    private AudioFileFormat applyDetector(File file, IFileFormatDetector detector, AudioFileFormat fileFormat) throws IOException, UnsupportedAudioFileException {
        long length;
        TAudioFileFormat taff;
        AudioFormat detectedFormat;
        AudioFormat audioFormat = fileFormat.getFormat();
        if ((audioFormat.getChannels() == -1 || audioFormat.getSampleRate() == -1.0f) && (detectedFormat = detector.detectFormat(file, audioFormat)) != audioFormat) {
            if (fileFormat instanceof TAudioFileFormat) {
                TAudioFileFormat taff2 = (TAudioFileFormat)fileFormat;
                fileFormat = new TAudioFileFormat(taff2.getType(), detectedFormat, taff2.getFrameLengthEx(), taff2.getByteLengthEx(), fileFormat.properties());
            } else {
                fileFormat = new TAudioFileFormat(fileFormat.getType(), detectedFormat, fileFormat.getFrameLength(), fileFormat.getByteLength(), fileFormat.properties());
            }
        }
        if (fileFormat instanceof TAudioFileFormat) {
            taff = (TAudioFileFormat)fileFormat;
            length = taff.getFrameLengthEx();
        } else {
            length = fileFormat.getFrameLength();
        }
        if (length == -1L && (length = detector.detectLength(file, fileFormat)) >= 0L) {
            if (fileFormat instanceof TAudioFileFormat) {
                taff = (TAudioFileFormat)fileFormat;
                fileFormat = new TAudioFileFormat(taff.getType(), taff.getFormat(), length, taff.getByteLengthEx(), fileFormat.properties());
            } else {
                fileFormat = new TAudioFileFormat(fileFormat.getType(), fileFormat.getFormat(), length, (long)fileFormat.getByteLength(), fileFormat.properties());
            }
        }
        return fileFormat;
    }

    private AudioFileFormat forceComputeLength(File file, IProgressMonitor progress, AudioFileFormat result) throws IOException, UnsupportedAudioFileException {
        Pair<AudioFormat, Long> info = this.getFormatAndFrameLength(file, result.getFormat(), progress);
        AudioFormat format = info.getFirst();
        long nbFrames = info.getSecond();
        result = new AudioFileFormatEx(result.getType(), format, nbFrames, result.properties());
        return result;
    }

    private Pair<AudioFormat, Long> getFormatAndFrameLength(File file, AudioFormat format, IProgressMonitor progress) throws IOException, UnsupportedAudioFileException {
        int bufferSize = 16384;
        IMultiChanAudioSource source = AudioFileIO.createAudioSource(file, progress);
        long nbFrames = 0L;
        float[][] buffer = new float[source.getAudioFormat().getChannels()][16384];
        int read = source.readSamples(buffer);
        while (read > 0) {
            nbFrames += (long)read;
            read = source.readSamples(buffer);
        }
        AudioFormat sourceFormat = ((AudioInputStreamSource)source).getBaseFormat();
        return new Pair<AudioFormat, Long>(sourceFormat, nbFrames);
    }

    public AudioFileFormat getAudioFileFormat(String fileName, File file) throws IOException, UnsupportedAudioFileException {
        AtomicBoolean threadSafe = new AtomicBoolean();
        if (fileName != null) {
            for (AudioFileReader reader : this.getAudioFileReaders(fileName, threadSafe)) {
                try {
                    if (!threadSafe.get()) {
                        readLock.lock();
                    }
                    AudioFileFormat audioFileFormat = reader.getAudioFileFormat(file);
                    return audioFileFormat;
                }
                catch (IOException ex) {
                    Debug.warn(ex);
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                }
                finally {
                    if (!threadSafe.get()) {
                        readLock.unlock();
                    }
                }
            }
        }
        if (!this.javaSoundFallback) {
            throw new UnsupportedAudioFileException("Unknown audio file format");
        }
        return AudioSystem.getAudioFileFormat(file);
    }

    public AudioFileFormat getAudioFileFormat(String fileName, InputStream fileInput) throws IOException, UnsupportedAudioFileException {
        TAudioFileFormat taff;
        AtomicBoolean threadSafe = new AtomicBoolean();
        if (fileName != null) {
            for (AudioFileReader reader : this.getAudioFileReaders(fileName, threadSafe)) {
                try {
                    TAudioFileFormat taff2;
                    AudioFileFormat result;
                    if (!threadSafe.get()) {
                        readLock.lock();
                    }
                    if ((result = reader.getAudioFileFormat(fileInput)) instanceof TAudioFileFormat && (taff2 = (TAudioFileFormat)result).getFrameLengthEx() != -1L) {
                        result = new AudioFileFormatEx(result.getType(), result.getFormat(), taff2.getFrameLengthEx(), result.properties());
                    }
                    AudioFileFormat audioFileFormat = result;
                    return audioFileFormat;
                }
                catch (IOException ex) {
                    Debug.warn(ex);
                }
                catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                }
                finally {
                    if (!threadSafe.get()) {
                        readLock.unlock();
                    }
                }
            }
        }
        if (!this.javaSoundFallback) {
            throw new UnsupportedAudioFileException("Unknown audio file format");
        }
        AudioFileFormat result = AudioSystem.getAudioFileFormat(fileInput);
        if (result instanceof TAudioFileFormat && (taff = (TAudioFileFormat)result).getFrameLengthEx() != -1L) {
            result = new AudioFileFormatEx(result.getType(), result.getFormat(), taff.getFrameLengthEx(), result.properties());
        }
        return result;
    }

    public static boolean isJreSupportedFormat(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot >= 0) {
            String extension = fileName.substring(lastDot).toLowerCase();
            return extension.equals(".wav") || extension.equals(".au") || extension.equals(".aif") || extension.equals(".aiff") || extension.equals(".aifc");
        }
        return false;
    }
}

