/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.audio.file.AudioEncodingType;
import ch.tachyon.tunnel.audio.utils.FormatUtils;
import ch.tachyon.tunnel.audio.utils.IOUtils;
import ch.tachyon.tunnel.audio.utils.OperationAbortedException;
import ch.tachyon.tunnel.common.AudioStreamFormat;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.tritonus.share.sampled.Encodings;

class AudioInputStreamSource
implements IMultiChanAudioSource,
Closeable {
    private final AudioInputStream stream;
    private final AudioFormat format;
    private final int nbChannels;
    private final boolean bigEndian;
    private final int bitsPerSample;
    private final boolean unsigned;
    private final int scale;
    private final AudioEncodingType encoding;
    private byte[] buffer;
    private float[] samples;
    private boolean closed = false;

    public AudioInputStreamSource(AudioInputStream stream) {
        this.stream = stream = AudioInputStreamSource.convertToLinear(stream);
        this.format = stream.getFormat();
        this.nbChannels = this.format.getChannels();
        if (this.nbChannels == -1) {
            throw new IllegalArgumentException("Number of channels is not specified");
        }
        this.bigEndian = this.format.isBigEndian();
        this.bitsPerSample = this.format.getSampleSizeInBits() == -1 ? 16 : this.format.getSampleSizeInBits();
        if (this.format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.unsigned = false;
        } else if (this.format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            this.unsigned = true;
        } else if (this.format.getEncoding().equals(Encodings.PCM_IEEE_FLOAT)) {
            this.unsigned = false;
        } else {
            throw new IllegalArgumentException("Unsupported encoding: " + this.format.getEncoding());
        }
        if (this.unsigned && this.bitsPerSample != 8) {
            throw new IllegalArgumentException("Unsigned format not supported for bits per sample of " + this.bitsPerSample);
        }
        this.scale = (this.bitsPerSample + 7) / 8;
        if (this.format.getEncoding().equals(Encodings.PCM_IEEE_FLOAT)) {
            this.encoding = this.bitsPerSample == 64 ? (this.bigEndian ? AudioEncodingType.ENC_DOUBLE_BE : AudioEncodingType.ENC_DOUBLE_LE) : (this.bigEndian ? AudioEncodingType.ENC_FLOAT_BE : AudioEncodingType.ENC_FLOAT_LE);
        } else if (this.bitsPerSample == 8) {
            this.encoding = this.unsigned ? AudioEncodingType.ENC_8BIT_U : AudioEncodingType.ENC_8BIT_S;
        } else if (this.bitsPerSample == 16) {
            this.encoding = this.bigEndian ? AudioEncodingType.ENC_16BIT_BE : AudioEncodingType.ENC_16BIT_LE;
        } else if (this.bitsPerSample == 24) {
            this.encoding = this.bigEndian ? AudioEncodingType.ENC_24BIT_BE : AudioEncodingType.ENC_24BIT_LE;
        } else if (this.bitsPerSample == 32) {
            this.encoding = this.bigEndian ? AudioEncodingType.ENC_32BIT_BE : AudioEncodingType.ENC_32BIT_LE;
        } else {
            throw new IllegalArgumentException("Unsupported bits per sample: " + this.bitsPerSample);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static AudioInputStream convertToLinear(AudioInputStream stream) {
        block10: {
            sourceFormat = stream.getFormat();
            result = null;
            try {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                if (sourceFormat.getSampleSizeInBits() == 8 && sourceFormat.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
                    encoding = AudioFormat.Encoding.PCM_UNSIGNED;
                } else if (sourceFormat.getEncoding().equals(Encodings.PCM_IEEE_FLOAT)) {
                    encoding = Encodings.PCM_IEEE_FLOAT;
                }
                sampleSizeInBits = sourceFormat.getSampleSizeInBits();
                if (sampleSizeInBits == -1) {
                    sampleSizeInBits = 16;
                }
                targetFormat = new AudioFormat(encoding, sourceFormat.getSampleRate(), sampleSizeInBits, sourceFormat.getChannels(), sourceFormat.getChannels() * sampleSizeInBits / 8, sourceFormat.getSampleRate(), sourceFormat.isBigEndian());
                result = AudioSystem.getAudioInputStream(targetFormat, stream);
                break block10;
            }
            catch (IllegalArgumentException ex) {
                ** for (targetFormat : AudioInputStreamSource.getPcmFormatsFor((AudioFormat)sourceFormat))
            }
lbl-1000:
            // 1 sources

            {
                try {
                    result = AudioSystem.getAudioInputStream(targetFormat, stream);
                    break;
                }
                catch (IllegalArgumentException var6_9) {
                    // empty catch block
                }
                continue;
            }
lbl24:
            // 2 sources

            if (result == null) {
                throw ex;
            }
        }
        return result;
    }

    private static List<AudioFormat> getPcmFormatsFor(AudioFormat sourceFormat) {
        ArrayList<AudioFormat> result = new ArrayList<AudioFormat>();
        AudioFormat[] targetFormatArr = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_SIGNED, sourceFormat);
        if (targetFormatArr != null) {
            result.addAll(Arrays.asList(targetFormatArr));
        }
        if ((targetFormatArr = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_UNSIGNED, sourceFormat)) != null) {
            result.addAll(Arrays.asList(targetFormatArr));
        }
        if ((targetFormatArr = AudioSystem.getTargetFormats(AudioFormat.Encoding.PCM_FLOAT, sourceFormat)) != null) {
            result.addAll(Arrays.asList(targetFormatArr));
        }
        return result;
    }

    @Override
    public AudioStreamFormat getAudioFormat() {
        AudioFormat aFmt = new AudioFormat(this.format.getSampleRate(), this.format.getSampleSizeInBits(), this.format.getChannels(), true, false);
        return FormatUtils.toStreamFormat(aFmt);
    }

    public AudioFormat getBaseFormat() {
        return this.format;
    }

    @Override
    public int readSamples(float[][] target) {
        if (target.length != this.nbChannels) {
            throw new IllegalArgumentException("Number fo channels does not match");
        }
        int chanLength = target[0].length;
        int fullLength = chanLength * this.nbChannels;
        int bLength = fullLength * this.scale;
        if (this.buffer == null || this.buffer.length < bLength) {
            this.buffer = new byte[bLength];
        }
        if (this.samples == null || this.samples.length < fullLength) {
            this.samples = new float[fullLength];
        }
        try {
            int amount = 0;
            while (amount < bLength) {
                if (this.closed) break;
                int read = this.stream.read(this.buffer, amount, bLength - amount);
                if (read < 0) {
                    this.closed = true;
                    this.stream.close();
                    break;
                }
                amount += read;
            }
            assert (amount % (this.scale * this.nbChannels) == 0);
            fullLength = amount / this.scale;
            chanLength = fullLength / this.nbChannels;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (OperationAbortedException ex) {
            if (!this.closed) {
                this.closed = true;
                IOUtils.close(this.stream);
            }
            throw ex;
        }
        this.encoding.decode(this.buffer, this.samples, fullLength);
        this.decodeChannels(this.samples, target, chanLength);
        return chanLength;
    }

    private void decodeChannels(float[] samples, float[][] target, int chanLength) {
        if (this.nbChannels == 1) {
            System.arraycopy(samples, 0, target[0], 0, chanLength);
        } else {
            int chan = 0;
            while (chan < this.nbChannels) {
                int i = 0;
                while (i < chanLength) {
                    target[chan][i] = samples[i * this.nbChannels + chan];
                    ++i;
                }
                ++chan;
            }
        }
    }

    public int getNbChannels() {
        return this.nbChannels;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            IOUtils.close(this.stream);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

