/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.audio.file.AudioFileIO;
import ch.tachyon.tunnel.audio.utils.FormatUtils;
import ch.tachyon.tunnel.audio.utils.IProgressMonitor;
import ch.tachyon.tunnel.audio.utils.OperationAbortedException;
import ch.tachyon.tunnel.common.AudioStreamFormat;
import ch.tachyon.tunnel.common.IMultiChanAudioSink;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.utils.Debug;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Exchanger;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sound.sampled.AudioFileFormat;

public class OutputStreamSaveAudioSink
implements IMultiChanAudioSink,
Closeable {
    private final Thread writer;
    private final Exchanger<float[][]> exchanger = new Exchanger();
    private float[][] dstBuffer1;
    private float[][] dstBuffer2;
    private float[][] srcBuffer;
    private int srcOffset;
    private volatile boolean closed;
    private volatile boolean aborted;
    private IOException ioEx;
    private OperationAbortedException abortion;
    private AtomicInteger nbWriters = new AtomicInteger();

    public OutputStreamSaveAudioSink(final OutputStream target, final AudioFileFormat saveFormat, final IProgressMonitor progress) {
        this.writer = new Thread(new Runnable(){

            @Override
            public void run() {
                IMultiChanAudioSource pipedSource = new IMultiChanAudioSource(){

                    @Override
                    public int readSamples(float[][] target) {
                        return OutputStreamSaveAudioSink.this.readSamples(target);
                    }

                    @Override
                    public AudioStreamFormat getAudioFormat() {
                        return FormatUtils.toStreamFormat(saveFormat.getFormat());
                    }

                    @Override
                    public void close() {
                    }
                };
                try {
                    AudioFileIO.saveAudioFile(pipedSource, target, saveFormat, progress);
                }
                catch (IOException ex) {
                    OutputStreamSaveAudioSink.this.ioEx = ex;
                }
                catch (OperationAbortedException ex) {
                    OutputStreamSaveAudioSink.this.abortion = ex;
                }
                OutputStreamSaveAudioSink.this.aborted = true;
                while (OutputStreamSaveAudioSink.this.nbWriters.get() > 0) {
                    try {
                        OutputStreamSaveAudioSink.this.exchanger.exchange(null);
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        });
        this.writer.setName("OutputStreamSaveAudioSink");
        this.writer.start();
    }

    int readSamples(float[][] dstBuffer) {
        int length = dstBuffer[0].length;
        int dstOffset = 0;
        int result = 0;
        while (dstOffset < length) {
            if (this.srcBuffer == null || this.srcOffset >= this.srcBuffer[0].length) {
                if (this.closed) {
                    return result;
                }
                try {
                    this.srcBuffer = this.exchanger.exchange(null);
                }
                catch (InterruptedException ex) {
                    return result;
                }
                if (this.srcBuffer == null) {
                    return result;
                }
                this.srcOffset = 0;
            }
            int amount = Math.min(length - dstOffset, this.srcBuffer[0].length - this.srcOffset);
            int c = 0;
            while (c < dstBuffer.length) {
                System.arraycopy(this.srcBuffer[c], this.srcOffset, dstBuffer[c], dstOffset, amount);
                ++c;
            }
            dstOffset += amount;
            this.srcOffset += amount;
            result += amount;
        }
        return result;
    }

    @Override
    public void writeSamples(float[][] samples) {
        this.nbWriters.incrementAndGet();
        try {
            if (this.aborted) {
                if (this.abortion != null) {
                    throw this.abortion;
                }
                if (this.ioEx != null) {
                    throw new RuntimeException(this.ioEx);
                }
                return;
            }
            if (this.dstBuffer1 == null || this.dstBuffer1.length != samples.length || this.dstBuffer1[0].length != samples[0].length) {
                this.dstBuffer1 = new float[samples.length][samples[0].length];
            }
            int c = 0;
            while (c < samples.length) {
                System.arraycopy(samples[c], 0, this.dstBuffer1[c], 0, samples[c].length);
                ++c;
            }
            try {
                this.exchanger.exchange(this.dstBuffer1);
            }
            catch (InterruptedException ex) {
                Debug.warn(ex);
            }
            float[][] temp = this.dstBuffer1;
            this.dstBuffer1 = this.dstBuffer2;
            this.dstBuffer2 = temp;
        }
        finally {
            this.nbWriters.decrementAndGet();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        while (this.writer.isAlive()) {
            this.writer.interrupt();
            try {
                this.writer.join(100L);
            }
            catch (InterruptedException ex) {
                Debug.warn(ex);
                break;
            }
        }
    }
}

