/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.audio.utils.IProgressMonitor;
import java.io.File;
import java.io.IOException;
import org.tritonus.share.sampled.file.RandomFileInputStream;

public class RandomFileProgressInputStream
extends RandomFileInputStream {
    private final IProgressMonitor progress;
    private boolean closed;

    public RandomFileProgressInputStream(File file) throws IOException {
        this(file, null);
    }

    public RandomFileProgressInputStream(File file, IProgressMonitor progress) throws IOException {
        super(file);
        this.progress = progress;
    }

    public int read() throws IOException {
        this.updateProgress();
        return super.read();
    }

    public void close() throws IOException {
        this.updateProgress();
        super.close();
        this.closed = true;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.updateProgress();
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        this.updateProgress();
        return super.read(b);
    }

    public synchronized void reset() throws IOException {
        super.reset();
        this.updateProgress();
    }

    public long skip(long n) throws IOException {
        this.updateProgress();
        return super.skip(n);
    }

    private void updateProgress() throws IOException {
        if (this.progress == null || this.closed) {
            return;
        }
        double pos = (double)super.getFilePointer() / (double)super.getFileSize();
        this.progress.setProgress(pos, 1.0);
    }
}

